/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;

public class DeployableProductFileNodeFilter
implements ITreeNodeFilter {
    public static final String BUNDLE_ID_HTTP_REGISTRY = "org.eclipse.equinox.http.registry";
    public static final String BUNDLE_ID_HTTP_SERVLETBRIDGE = "org.eclipse.equinox.http.servletbridge";
    private final int m_nodeType;

    public DeployableProductFileNodeFilter(int nodeType) {
        this.m_nodeType = nodeType;
    }

    @Override
    public boolean accept(ITreeNode node) {
        if (node.getType() == this.m_nodeType) {
            return true;
        }
        if (node.getType() == 2999) {
            return this.getServletBridgeProductStatus((IFile)node.getData()).isOK();
        }
        return false;
    }

    private IStatus getServletBridgeProductStatus(IFile productFile) {
        if (productFile == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "product file is null.");
        }
        ProductFileModelHelper h = null;
        try {
            h = new ProductFileModelHelper(productFile);
            if (!h.ProductFile.isValid()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "product file is not valid.");
            }
            if (!h.ProductFile.existsDependency(BUNDLE_ID_HTTP_REGISTRY)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "product must contain 'org.eclipse.equinox.http.registry' as required bundle.");
            }
            if (!h.ProductFile.existsDependency(BUNDLE_ID_HTTP_SERVLETBRIDGE)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "product must contain 'org.eclipse.equinox.http.servletbridge' as required bundle.");
            }
            String osgiBundleEntry = h.ConfigurationFile.getOsgiBundlesEntry();
            if (osgiBundleEntry == null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "osgi.bundles entry in config.ini is missing.");
            }
            if (!osgiBundleEntry.contains(BUNDLE_ID_HTTP_SERVLETBRIDGE)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "osgi.bundles entry in config.ini file must conatin 'org.eclipse.equinox.http.servletbridge' bundle.");
            }
            if (!osgiBundleEntry.contains(BUNDLE_ID_HTTP_REGISTRY)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "osgi.bundles entry in config.ini file must conatin 'org.eclipse.equinox.http.registry' bundle.");
            }
        }
        catch (CoreException coreException) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "could not parse product file.");
        }
        return Status.OK_STATUS;
    }
}

