/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service;

import java.util.Comparator;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.create.ServiceOperationNewAction;
import org.eclipse.scout.sdk.ui.action.rename.ServiceRenameAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServiceOperationNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.MethodComparators;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public abstract class AbstractServiceNodePage
extends AbstractScoutTypePage {
    private final IType m_interfaceType;
    private final String m_readOnlySuffix;
    private P_ServiceMethodsListener m_serviceMethodListener;

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public AbstractServiceNodePage(AbstractPage parent, IType type, IType interfaceType, String readOnlySuffix) {
        this.setParent(parent);
        this.setType(type);
        this.m_interfaceType = interfaceType;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service.png"));
        this.m_readOnlySuffix = readOnlySuffix;
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceMethodListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeMethodChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_serviceMethodListener);
            this.m_serviceMethodListener = null;
        }
        super.unloadPage();
    }

    @Override
    public void loadChildrenImpl() {
        if (this.m_interfaceType == null) {
            return;
        }
        if (this.m_serviceMethodListener == null) {
            this.m_serviceMethodListener = new P_ServiceMethodsListener();
            TypeCacheAccessor.getJavaResourceChangedEmitter().addMethodChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_serviceMethodListener);
        }
        IMethod[] serviceMethods = TypeUtility.getMethods((IType)this.getType(), (IMethodFilter)MethodFilters.getFlagsFilter((int)1), (Comparator)MethodComparators.getNameComparator());
        try {
            int n;
            int n2;
            IMethod[] iMethodArray;
            TreeMap<String, IMethod> interfaceMethodsMap = new TreeMap<String, IMethod>();
            if (TypeUtility.exists((IJavaElement)this.getInterfaceType())) {
                iMethodArray = TypeUtility.getMethods((IType)this.getInterfaceType(), (IMethodFilter)MethodFilters.getFlagsFilter((int)1), (Comparator)MethodComparators.getNameComparator());
                n2 = iMethodArray.length;
                n = 0;
                while (n < n2) {
                    IMethod m = iMethodArray[n];
                    interfaceMethodsMap.put(SignatureUtility.getMethodIdentifier((IMethod)m), m);
                    ++n;
                }
            }
            iMethodArray = serviceMethods;
            n2 = serviceMethods.length;
            n = 0;
            while (n < n2) {
                IMethod implMethod = iMethodArray[n];
                new ServiceOperationNodePage(this, (IMethod)interfaceMethodsMap.get(SignatureUtility.getMethodIdentifier((IMethod)implMethod)), implMethod);
                ++n;
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError(e);
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ServiceRenameAction.class, ShowJavaReferencesAction.class, FormDataSqlBindingValidateAction.class, ServiceOperationNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof ServiceRenameAction) {
            ServiceRenameAction sra = (ServiceRenameAction)menu;
            sra.setServiceImplementation(this.getType());
            sra.setServiceInterface(this.getInterfaceType());
            sra.setReadOnlySuffix(this.m_readOnlySuffix);
            sra.setOldName(this.getType().getElementName());
        } else if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setServices(this.getType());
        } else if (menu instanceof ServiceOperationNewAction) {
            ((ServiceOperationNewAction)menu).init(this.getInterfaceType(), this.getType());
        }
    }

    public IType getInterfaceType() {
        return this.m_interfaceType;
    }

    private class P_ServiceMethodsListener
    implements IJavaResourceChangedListener {
        private P_ServiceMethodsListener() {
        }

        public void handleEvent(JdtEvent event) {
            AbstractServiceNodePage.this.markStructureDirty();
        }
    }
}

