/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.action.LegacyOperationAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractValuePresenter<T>
extends AbstractMethodPresenter {
    private Text m_textComponent;
    private final String m_regexAllowedCharacters;
    private T m_currentSourceValue;
    private T m_defaultValue;

    public AbstractValuePresenter(PropertyViewFormToolkit toolkit, Composite parent, String regexAllowedCharacters) {
        super(toolkit, parent);
        this.m_regexAllowedCharacters = regexAllowedCharacters;
    }

    @Override
    protected Control createContent(Composite container) {
        this.m_textComponent = this.getToolkit().createText(container, "", 0x800 | this.getTextAlignment() | (this.isMultiLine() ? 770 : 0));
        this.m_textComponent.setEnabled(false);
        P_TextListener listener = new P_TextListener();
        this.m_textComponent.addListener(15, (Listener)listener);
        this.m_textComponent.addListener(16, (Listener)listener);
        this.m_textComponent.addListener(25, (Listener)listener);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu((Control)this.m_textComponent);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager managerInside) {
                managerInside.removeAll();
                AbstractValuePresenter.this.createContextMenu((MenuManager)managerInside);
            }
        });
        this.m_textComponent.setMenu(menu);
        return this.m_textComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_textComponent.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_textComponent.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        super.init(method);
        String defValue = this.getMethod().computeDefaultValue();
        String value = this.getMethod().computeValue();
        this.m_defaultValue = this.parseSourceInput(defValue);
        if (CompareUtility.equals((Object)defValue, (Object)value)) {
            this.setCurrentSourceValue(this.m_defaultValue);
        } else {
            this.setCurrentSourceValue(this.parseSourceInput(value));
        }
        String initialText = this.formatDisplayValue(this.getCurrentSourceValue());
        this.m_textComponent.setText(initialText);
        this.m_textComponent.setEnabled(true);
    }

    protected abstract String formatSourceValue(T var1) throws CoreException;

    protected abstract String formatDisplayValue(T var1) throws CoreException;

    protected abstract T parseSourceInput(String var1) throws CoreException;

    protected abstract T parseDisplayInput(String var1) throws CoreException;

    protected abstract void storeValue(T var1) throws CoreException;

    protected int getTextAlignment() {
        return 16384;
    }

    protected final void setCurrentSourceValue(T value) {
        if (CompareUtility.notEquals(value, this.m_currentSourceValue)) {
            this.m_currentSourceValue = value;
            this.execCurrentSourceValueChanged(this.m_currentSourceValue);
        }
    }

    protected void execCurrentSourceValueChanged(T value) {
    }

    public T getCurrentSourceValue() {
        return this.m_currentSourceValue;
    }

    public T getDefaultValue() {
        return this.m_defaultValue;
    }

    public Text getTextComponent() {
        return this.m_textComponent;
    }

    protected void createContextMenu(MenuManager manager) {
        if (this.getMethod() != null && this.getMethod().isImplemented()) {
            manager.add((IAction)new LegacyOperationAction(Texts.get((String)"SetDefaultValue"), ScoutSdkUi.getImageDescriptor("info.gif"), (IOperation)new ScoutMethodDeleteOperation(this.getMethod().peekMethod())));
        }
    }

    private class P_TextListener
    implements Listener {
        private P_TextListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 25: {
                    String string;
                    if (AbstractValuePresenter.this.m_regexAllowedCharacters == null || (string = event.text) == null) break;
                    event.doit = Pattern.matches(AbstractValuePresenter.this.m_regexAllowedCharacters, string);
                    if (event.doit) break;
                    ScoutSdkUi.logInfo("not allowed input: " + string);
                    break;
                }
                case 16: {
                    String input = AbstractValuePresenter.this.getTextComponent().getText();
                    try {
                        Object value = AbstractValuePresenter.this.parseDisplayInput(input);
                        String displayValue = AbstractValuePresenter.this.formatDisplayValue(value);
                        AbstractValuePresenter.this.getTextComponent().setText(displayValue);
                        if (CompareUtility.equals(value, AbstractValuePresenter.this.getCurrentSourceValue())) break;
                        AbstractValuePresenter.this.storeValue(value);
                        AbstractValuePresenter.this.setCurrentSourceValue(value);
                    }
                    catch (CoreException coreException) {
                        ScoutSdkUi.logInfo("input is not well formed " + input);
                        AbstractValuePresenter.this.getTextComponent().setForeground(AbstractValuePresenter.this.getTextComponent().getDisplay().getSystemColor(3));
                    }
                    break;
                }
                case 15: {
                    AbstractValuePresenter.this.getTextComponent().setForeground(null);
                    break;
                }
            }
        }
    }
}

