/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.library;

import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class JavaProjectSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = JavaProjectSelectionDialog.class.getName();
    private IJavaProject[] m_javaProjects;

    public JavaProjectSelectionDialog(Shell shell, boolean includeFragments, boolean multiSelect) {
        this(shell, JavaProjectSelectionDialog.getAllWorkspaceScoutProjects(includeFragments), multiSelect);
    }

    public JavaProjectSelectionDialog(Shell shell, IJavaProject[] projects, boolean multiSelect) {
        super(shell, multiSelect);
        this.setListLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        this.setInitialPattern("**");
        this.m_javaProjects = projects;
    }

    public static IJavaProject[] getAllWorkspaceScoutProjects(boolean includeFragments) {
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        LinkedList<IJavaProject> plugins = new LinkedList<IJavaProject>();
        IProject[] iProjectArray = workspaceProjects;
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.scout.sdk.ScoutNature") && !project.hasNature("org.eclipse.scout.sdk.ScoutLibraryNature")) {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    plugins.add(jp);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logWarning("could not validate plugin '" + project.getName() + "'.", e);
            }
            ++n2;
        }
        return plugins.toArray(new IJavaProject[plugins.size()]);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public int open() {
        return super.open();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new P_JavaProjectSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IJavaProject[] iJavaProjectArray = this.m_javaProjects;
        int n = this.m_javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            contentProvider.add((Object)project, itemsFilter);
            progressMonitor.worked(1);
            ++n2;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ScoutSdkUi.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ScoutSdkUi.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IJavaProject) {
            return ((IJavaProject)item).getElementName();
        }
        return null;
    }

    protected Comparator getItemsComparator() {
        return new P_JavaProjectSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.scout.sdk.ui", 0, "", null);
    }

    private class P_JavaProjectSearchComparator
    implements Comparator {
        private P_JavaProjectSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IJavaProject) {
                return 100;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IJavaProject && o2 instanceof IJavaProject) {
                IJavaProject ipmb1 = (IJavaProject)o1;
                IJavaProject ipmb2 = (IJavaProject)o2;
                return ipmb1.getElementName().compareTo(ipmb2.getElementName());
            }
            return 0;
        }
    }

    private class P_JavaProjectSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private P_JavaProjectSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)JavaProjectSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)item;
                id = project.getElementName();
            }
            return this.matches(id);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

