/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.toolbutton;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.OutlineToolbuttonNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.toolbutton.ToolbuttonNewWizardPage1;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class OutlineToolbuttonNewWizardPage
extends AbstractWorkspaceWizardPage {
    final IType iToolButton = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.tool.IToolButton");
    final IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private IType m_outline;
    private String m_typeName;
    private SiblingProposal m_sibling;
    private ProposalTextField m_outlineField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;

    public OutlineToolbuttonNewWizardPage(IType declaringType) {
        super(OutlineToolbuttonNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewOutlineToolButton"));
        this.setDescription(Texts.get((String)"CreateANewOutlineToolButton"));
        this.m_declaringType = declaringType;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_outlineField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"Outline"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                return new Object[][]{ScoutTypeUtility.getClassesOnClasspath((IType)OutlineToolbuttonNewWizardPage.this.iOutline, (IJavaProject)OutlineToolbuttonNewWizardPage.this.m_declaringType.getJavaProject())};
            }
        });
        this.m_outlineField.acceptProposal(this.getOutline());
        this.m_outlineField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    OutlineToolbuttonNewWizardPage.this.setStateChanging(true);
                    OutlineToolbuttonNewWizardPage.this.m_outline = (IType)event.proposal;
                    if (OutlineToolbuttonNewWizardPage.this.getOutline() != null && StringUtility.isNullOrEmpty((String)OutlineToolbuttonNewWizardPage.this.m_typeNameField.getModifiableText())) {
                        OutlineToolbuttonNewWizardPage.this.m_typeNameField.setText(OutlineToolbuttonNewWizardPage.this.getOutline().getElementName());
                    }
                }
                finally {
                    OutlineToolbuttonNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Tool");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OutlineToolbuttonNewWizardPage.this.m_typeName = OutlineToolbuttonNewWizardPage.this.m_typeNameField.getText();
                OutlineToolbuttonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField(parent, this.m_declaringType, TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.tool.IToolButton"));
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                OutlineToolbuttonNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                OutlineToolbuttonNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_outlineField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        OutlineToolbuttonNewOperation operation = new OutlineToolbuttonNewOperation(this.m_declaringType);
        operation.setTypeName(this.getTypeName());
        ToolbuttonNewWizardPage1 previousPage = (ToolbuttonNewWizardPage1)this.getWizard().getPage(ToolbuttonNewWizardPage1.class.getName());
        if (previousPage.getSuperType() != null) {
            operation.setSuperTypeSignature(Signature.createTypeSignature((String)previousPage.getSuperType().getFullyQualifiedName(), (boolean)true));
        }
        if (this.getOutline() != null) {
            operation.setOutlineType(this.getOutline());
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredOutline((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_TOOL_BUTTON));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusOutline());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Tool")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_fieldNull"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusOutline() {
        if (this.getOutline() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnOutlineMustBeSelected"));
        }
        return Status.OK_STATUS;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void setOutline(IType outline) {
        try {
            this.setStateChanging(true);
            this.m_outline = outline;
            if (this.isControlCreated()) {
                this.m_outlineField.acceptProposal(outline);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getOutline() {
        return this.m_outline;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

