/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.Comparator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.CachedTypeHierarchy;
import org.eclipse.scout.sdk.util.internal.typecache.CombinedHierarchy;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;

public class PrimaryTypeTypeHierarchy
extends CachedTypeHierarchy
implements IPrimaryTypeTypeHierarchy {
    private ITypeFilter m_primaryTypeFilter = new P_PrimaryTypeFilter();

    public PrimaryTypeTypeHierarchy(IType type) {
        super(type);
    }

    @Override
    public IType[] getAllSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllSubtypes(type, internalFilter, comparator);
    }

    @Override
    public IType[] getAllClasses(ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllClasses(internalFilter, comparator);
    }

    @Override
    public IType[] getAllInterfaces(ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllInterfaces(internalFilter, comparator);
    }

    @Override
    public IType[] getAllSuperclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllSuperclasses(type, internalFilter, comparator);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllSuperInterfaces(type, internalFilter, comparator);
    }

    @Override
    public IType[] getAllSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllSupertypes(type, internalFilter, comparator);
    }

    @Override
    public IType[] getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getAllTypes(internalFilter, comparator);
    }

    @Override
    public IType[] getSubclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getSubclasses(type, internalFilter, comparator);
    }

    @Override
    public IType[] getSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getSubtypes(type, internalFilter, comparator);
    }

    @Override
    public IType getSuperclass(IType type) {
        if (this.m_primaryTypeFilter.accept(type)) {
            return super.getSuperclass(type);
        }
        return null;
    }

    @Override
    public IType[] getSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getSuperInterfaces(type, internalFilter, comparator);
    }

    @Override
    public IType[] getSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        ITypeFilter internalFilter = null;
        internalFilter = filter == null ? this.m_primaryTypeFilter : TypeFilters.getMultiTypeFilter(filter, this.m_primaryTypeFilter);
        return super.getSupertypes(type, internalFilter, comparator);
    }

    @Override
    public org.eclipse.scout.sdk.util.typecache.ITypeHierarchy combinedTypeHierarchy(IRegion additionalRegion) {
        IType e;
        if (additionalRegion == null) {
            throw new IllegalArgumentException("additional region can not be null");
        }
        IRegion region = JavaCore.newRegion();
        IType[] iTypeArray = this.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            e = iTypeArray[n2];
            region.add((IJavaElement)e);
            ++n2;
        }
        iTypeArray = additionalRegion.getElements();
        n = iTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            e = iTypeArray[n2];
            region.add((IJavaElement)e);
            ++n2;
        }
        try {
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, null);
            return new CombinedHierarchy(this.getType(), hierarchy);
        }
        catch (JavaModelException e2) {
            SdkUtilActivator.logError("could not create combined type hierarchy for '" + this.getType().getFullyQualifiedName() + "'.", e2);
            return null;
        }
    }

    @Override
    public org.eclipse.scout.sdk.util.typecache.ITypeHierarchy combinedTypeHierarchy(IJavaElement ... additionalElements) {
        IType e;
        if (additionalElements == null) {
            throw new IllegalArgumentException("additional region can not be null");
        }
        IRegion region = JavaCore.newRegion();
        IType[] iTypeArray = this.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            e = iTypeArray[n2];
            region.add((IJavaElement)e);
            ++n2;
        }
        iTypeArray = additionalElements;
        n = additionalElements.length;
        n2 = 0;
        while (n2 < n) {
            e = iTypeArray[n2];
            region.add((IJavaElement)e);
            ++n2;
        }
        try {
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, null);
            return new CombinedHierarchy(this.getType(), hierarchy);
        }
        catch (JavaModelException e2) {
            SdkUtilActivator.logError("could not create combined type hierarchy for '" + this.getType().getFullyQualifiedName() + "'.", e2);
            return null;
        }
    }

    private class P_PrimaryTypeFilter
    implements ITypeFilter {
        private P_PrimaryTypeFilter() {
        }

        @Override
        public boolean accept(IType type) {
            return type.getDeclaringType() == null;
        }
    }
}

