/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt.finegraned;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedAstMatcher;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedJavaElementDelta;

class FineGrainedAstAnalyzer {
    private IJavaElementDelta m_delta;
    private ICompilationUnit m_icu;

    public FineGrainedAstAnalyzer(IJavaElementDelta delta) {
        this.m_delta = delta;
        this.m_icu = (ICompilationUnit)delta.getElement();
    }

    public FineGrainedJavaElementDelta[] calculateDeltas(String oldContent, String newContent) {
        if (CompareUtility.equals((Object)oldContent, (Object)newContent)) {
            return new FineGrainedJavaElementDelta[0];
        }
        CompilationUnit oldAst = null;
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setCompilerOptions((Map)JavaCore.getOptions());
        parser.setKind(8);
        parser.setSource(oldContent.toCharArray());
        oldAst = (CompilationUnit)parser.createAST(null);
        CompilationUnit newAst = this.m_delta.getCompilationUnitAST();
        if (newAst == null) {
            ASTParser parser2 = ASTParser.newParser((int)3);
            parser2.setCompilerOptions((Map)JavaCore.getOptions());
            parser2.setKind(8);
            parser2.setSource(newContent.toCharArray());
            newAst = (CompilationUnit)parser2.createAST(null);
        }
        return this.calculateDeltas(oldAst, newAst);
    }

    public FineGrainedJavaElementDelta[] calculateDeltas(CompilationUnit oldAst, CompilationUnit newAst) {
        final HashSet set = new HashSet();
        FineGrainedAstMatcher matcher = new FineGrainedAstMatcher(){

            @Override
            protected boolean processDelta(boolean match, ASTNode node, Object other) {
                if (!match) {
                    try {
                        IJavaElement e = FineGrainedAstAnalyzer.this.m_icu.getElementAt(node.getStartPosition());
                        if (e != null) {
                            set.add(new FineGrainedJavaElementDelta(e));
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                return true;
            }
        };
        newAst.subtreeMatch((ASTMatcher)matcher, (Object)oldAst);
        return set.toArray(new FineGrainedJavaElementDelta[set.size()]);
    }
}

