/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.util.signature.IImportValidator;

public class SimpleImportValidator
implements IImportValidator {
    private HashMap<String, String> m_newImports = new HashMap();
    private String m_packageName;
    private static final Pattern EXT_REGEX = Pattern.compile("^\\+.*$");
    private static final Pattern EXT_REPL_REGEX = Pattern.compile("^\\+");
    private static final Pattern PLAIN_REPL_REGEX = Pattern.compile("^[\\[\\+]*");

    public SimpleImportValidator() {
        this(null);
    }

    public SimpleImportValidator(String packageName) {
        this.m_packageName = packageName;
    }

    @Override
    public String getTypeName(String singleTypeSignature) {
        String prefix = "";
        if (EXT_REGEX.matcher(singleTypeSignature).matches()) {
            prefix = "? extends ";
            singleTypeSignature = EXT_REPL_REGEX.matcher(singleTypeSignature).replaceAll("");
        }
        if (singleTypeSignature.charAt(0) == 'Q') {
            return Signature.getSignatureSimpleName((String)singleTypeSignature);
        }
        String pckName = Signature.getSignatureQualifier((String)singleTypeSignature);
        String simpleName = Signature.getSignatureSimpleName((String)singleTypeSignature);
        String plainSimpleName = Signature.getSignatureSimpleName((String)PLAIN_REPL_REGEX.matcher(singleTypeSignature).replaceAll(""));
        if (this.isAlreadyUsed(pckName, plainSimpleName)) {
            return String.valueOf(prefix) + pckName + "." + simpleName;
        }
        this.m_newImports.put(plainSimpleName, pckName);
        return String.valueOf(prefix) + simpleName;
    }

    protected boolean isAlreadyUsed(String packageName, String simpleName) {
        String usedPackageName = this.m_newImports.get(simpleName);
        return usedPackageName != null && !usedPackageName.equals(packageName);
    }

    protected boolean isSamePackage(String packageName) {
        if (this.m_packageName != null) {
            return this.m_packageName.equals(packageName);
        }
        return false;
    }

    @Override
    public void addImport(String fqn) {
        String packageName = Signature.getQualifier((String)fqn);
        String simpleName = Signature.getSimpleName((String)fqn);
        this.m_newImports.put(simpleName, packageName);
    }

    @Override
    public String[] getImportsToCreate() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.m_newImports.entrySet()) {
            if (e.getValue().equals("java.lang") || this.isSamePackage(e.getValue())) continue;
            list.add(String.valueOf(e.getValue()) + "." + e.getKey());
        }
        return list.toArray(new String[list.size()]);
    }
}

