/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.regex.Pattern;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.IFieldFilter;

public class FieldFilters {
    public static IFieldFilter getFlagsFilter(final int flags) {
        return new IFieldFilter(){

            @Override
            public boolean accept(IField field) {
                try {
                    return (flags & field.getFlags()) == flags;
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logWarning("could not filter field '" + field.getElementName() + "' on '" + field.getDeclaringType().getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static IFieldFilter getNameRegexFilter(final Pattern regex) {
        return new IFieldFilter(){

            @Override
            public boolean accept(IField field) {
                return regex.matcher(field.getElementName()).matches();
            }
        };
    }

    public static IFieldFilter getPrivateNotStaticNotFinalNotAbstract() {
        return new IFieldFilter(){

            @Override
            public boolean accept(IField field) {
                try {
                    int flags = field.getFlags();
                    return Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && !Flags.isFinal((int)flags) && !Flags.isAbstract((int)flags);
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logWarning("could not filter field '" + field.getElementName() + "' on '" + field.getDeclaringType().getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static IFieldFilter getCompositeFilter(final IFieldFilter ... filters) {
        return new IFieldFilter(){

            @Override
            public boolean accept(IField field) {
                IFieldFilter[] iFieldFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IFieldFilter f = iFieldFilterArray[n2];
                    if (!f.accept(field)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }
}

