/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.regex.Pattern;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public final class MethodFilters {
    private MethodFilters() {
    }

    public static IMethodFilter getFilterWithAnnotation(final IType annotationType) {
        return new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                IAnnotation annotation = method.getAnnotation(annotationType.getElementName());
                if (TypeUtility.exists((IJavaElement)annotation)) {
                    return true;
                }
                annotation = method.getAnnotation(annotationType.getFullyQualifiedName());
                return TypeUtility.exists((IJavaElement)annotation);
            }
        };
    }

    public static IMethodFilter getNameFilter(final String methodName) {
        return new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                return method.getElementName().equals(methodName);
            }
        };
    }

    public static IMethodFilter getNameRegexFilter(final Pattern regex) {
        return new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                return regex.matcher(method.getElementName()).matches();
            }
        };
    }

    public static IMethodFilter getFlagsFilter(final int flags) {
        return new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                try {
                    return (method.getFlags() & flags) == flags;
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logError("could not get flags of method '" + method.getElementName() + "' in type '" + method.getDeclaringType().getFullyQualifiedName() + "'.", e);
                    return false;
                }
            }
        };
    }

    public static IMethodFilter getSuperMethodFilter(final IMethod method) {
        return new IMethodFilter(){

            @Override
            public boolean accept(IMethod candidate) {
                if (TypeUtility.exists((IJavaElement)candidate) && candidate.getElementName().equals(method.getElementName())) {
                    String[] candidateParameters = candidate.getParameterTypes();
                    String[] methodParameters = method.getParameterTypes();
                    if (methodParameters.length == candidateParameters.length) {
                        int i = 0;
                        while (i < candidateParameters.length) {
                            int mArrCount;
                            String cParam = candidateParameters[i];
                            String mParam = methodParameters[i];
                            int cArrCount = Signature.getArrayCount((String)cParam);
                            if (cArrCount != (mArrCount = Signature.getArrayCount((String)mParam))) {
                                return false;
                            }
                            cParam = cParam.substring(cArrCount);
                            mParam = mParam.substring(mArrCount);
                            mParam = Signature.getTypeErasure((String)mParam);
                            if (Signature.getTypeSignatureKind((String)(cParam = Signature.getTypeErasure((String)cParam))) != 3 && Signature.getTypeSignatureKind((String)mParam) != 3 && !Signature.getSignatureSimpleName((String)mParam).equals(Signature.getSignatureSimpleName((String)cParam))) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static IMethodFilter getMultiMethodFilter(final IMethodFilter ... filters) {
        return new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                if (filters == null) {
                    return true;
                }
                IMethodFilter[] iMethodFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethodFilter f = iMethodFilterArray[n2];
                    if (!f.accept(method)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }
}

