/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.ast;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.ast.VariableType;
import org.eclipse.scout.sdk.util.ast.visitor.TypeSignatureResolveVisitor;
import org.eclipse.scout.sdk.util.ast.visitor.VariableResolveVisitor;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public final class AstUtility {
    public static VariableType getTypeSignature(ASTNode node, ASTNode rootNode, IJavaElement containerElement) {
        TypeSignatureResolveVisitor visitor = new TypeSignatureResolveVisitor(rootNode, containerElement);
        node.accept((ASTVisitor)visitor);
        VariableType var = new VariableType("");
        var.setTypeSignature(visitor.getTypeSignature());
        var.addAssignedSignatures(visitor.getAssignedSignatures());
        return var;
    }

    public static VariableType resolveVariable(String variableName, IJavaElement containerElement, ASTNode rootNode, ASTNode stopNode) {
        VariableResolveVisitor visitor = new VariableResolveVisitor(variableName, containerElement, rootNode, stopNode);
        rootNode.accept((ASTVisitor)visitor);
        VariableType var = new VariableType(variableName);
        var.addAssignedSignatures(visitor.getAssignedTypesSignatures());
        var.setTypeSignature(visitor.getVariableTypeSignature());
        return var;
    }

    public static String resolveReturnValueSignature(String typeSignature, String methodName) {
        try {
            IMethod method;
            IType refType;
            if (!StringUtility.isNullOrEmpty((String)typeSignature) && TypeUtility.exists((IJavaElement)(refType = TypeUtility.getTypeBySignature(typeSignature))) && TypeUtility.exists((IJavaElement)(method = TypeUtility.getMethod(refType, methodName)))) {
                return SignatureUtility.getResolvedSignature(method.getReturnType(), refType);
            }
        }
        catch (JavaModelException javaModelException) {
            SdkUtilActivator.logError("could not parse return type of method '" + methodName + "' on type '" + typeSignature + "'");
        }
        return null;
    }
}

