/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.resources;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Document;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;

public final class ResourceUtility {
    public static final int BUF_SIZE = 8192;

    private ResourceUtility() {
    }

    public static IResource[] getAllResources(IResourceFilter filter) throws CoreException {
        return ResourceUtility.getAllResources((IResource)ResourcesPlugin.getWorkspace().getRoot(), filter);
    }

    public static IResource[] getAllResources(IResource startResource, IResourceFilter filter) throws CoreException {
        LinkedList<IResource> collector = new LinkedList<IResource>();
        ResourceUtility.collectResourcesRec(startResource, collector, filter);
        return collector.toArray(new IResource[collector.size()]);
    }

    private static void collectResourcesRec(IResource resource, Collection<IResource> collector, IResourceFilter filter) throws CoreException {
        if (ResourceUtility.exists(resource)) {
            if (filter.accept(resource)) {
                collector.add(resource);
            }
            if (resource instanceof IContainer) {
                IResource[] iResourceArray = ((IContainer)resource).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    ResourceUtility.collectResourcesRec(child, collector, filter);
                    ++n2;
                }
            }
        }
    }

    public static void showUrlInBrowser(String url) {
        try {
            Desktop d;
            if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                d.browse(new URI(url));
            }
        }
        catch (Throwable e) {
            SdkUtilActivator.logWarning("Could not open web browser. ", e);
        }
    }

    public static boolean exists(IResource resource) {
        return resource != null && resource.exists();
    }

    public static String getLineSeparator(Document doc) {
        String delim;
        if (doc != null && (delim = doc.getDefaultLineDelimiter()) != null) {
            return delim;
        }
        return ResourceUtility.getLineSeparator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContent(IFile f) throws CoreException {
        String string;
        InputStream is = null;
        try {
            is = f.getContents();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            String line = null;
            String nl = ResourceUtility.getLineSeparator((IResource)f);
            while (true) {
                if ((line = reader.readLine()) == null) {
                    string = sb.toString();
                    if (is == null) return string;
                    break;
                }
                sb.append(line);
                sb.append(nl);
            }
        }
        catch (IOException e) {
            try {
                throw new CoreException((IStatus)new ScoutStatus(e));
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public static File getEclipseInstallLocation() {
        Location l = Platform.getInstallLocation();
        File ret = null;
        if (l != null) {
            ret = new File(l.getURL().getPath());
        }
        return ret;
    }

    public static void addFolderToZip(File baseDir, ZipOutputStream zOut) throws IOException {
        ResourceUtility.addFolderToZipRec(baseDir, baseDir, zOut);
    }

    private static void addFolderToZipRec(File baseDir, File file, ZipOutputStream zOut) throws IOException {
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("source directory " + file + " does not exist or is not a folder");
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.exists() && !f.isHidden()) {
                if (f.isDirectory()) {
                    ResourceUtility.addFolderToZipRec(baseDir, f, zOut);
                } else {
                    String name = f.getAbsolutePath();
                    String prefix = baseDir.getAbsolutePath();
                    if (prefix.endsWith("/") || prefix.endsWith("\\")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    name = name.substring(prefix.length() + 1);
                    name = name.replace('\\', '/');
                    zOut.putNextEntry(new ZipEntry(name));
                    ResourceUtility.copy(f, (OutputStream)zOut);
                    zOut.closeEntry();
                }
            }
            ++n2;
        }
    }

    public static String getLineSeparator() {
        return Util.getLineSeparator(null, null);
    }

    public static String getLineSeparator(IResource r) {
        if (r != null) {
            IScopeContext[] scopeContext = new IScopeContext[]{new ProjectScope(r.getProject())};
            String lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        return ResourceUtility.getLineSeparator();
    }

    public static String getLineSeparator(IOpenable o) {
        try {
            return o.findRecommendedLineSeparator();
        }
        catch (JavaModelException javaModelException) {
            return ResourceUtility.getLineSeparator();
        }
    }

    public static void copy(File from, OutputStream to) throws IOException {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(from), 8192);
            ResourceUtility.copy(input, to);
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void mkdirs(IFile toCreate, IProgressMonitor monitor) throws CoreException {
        if (toCreate == null || toCreate.exists()) {
            return;
        }
        ResourceUtility.mkdirs(toCreate.getParent(), monitor);
    }

    public static void mkdirs(IContainer toCreate, IProgressMonitor monitor) throws CoreException {
        if (toCreate == null || toCreate.exists()) {
            return;
        }
        IContainer parent = toCreate.getParent();
        if (parent instanceof IFolder) {
            ResourceUtility.mkdirs(parent, monitor);
        }
        if (toCreate instanceof IFolder) {
            ((IFolder)toCreate).create(true, true, monitor);
        }
    }

    public static void moveFile(File from, File destFolder) throws IOException {
        if (from == null || !from.isFile()) {
            throw new IOException("source file is not valid");
        }
        if (destFolder == null) {
            throw new IOException("destination folder is not valid");
        }
        destFolder.mkdirs();
        boolean success = from.renameTo(destFolder);
        if (!success) {
            FileUtility.copyFile((File)from, (File)new File(destFolder, from.getName()));
            IOUtility.deleteFile((String)from.getAbsolutePath());
        }
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        ResourceUtility.copy(from, to, 8192);
    }

    public static void copy(InputStream from, OutputStream to, int bufferSize) throws IOException {
        int len;
        byte[] b = new byte[bufferSize];
        while ((len = from.read(b, 0, b.length)) != -1) {
            to.write(b, 0, len);
        }
        to.flush();
    }
}

