/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.WsFileMoveWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class DiscouragedWsdlFolderCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private IFolder m_newFolder;
    private String m_markerGroupUUID;
    private WebserviceEnum m_webserviceEnum;

    public DiscouragedWsdlFolderCommand(IScoutBundle bundle, String markerGroupUUID, BuildJaxWsBean buildJaxWsBean, SunJaxWsBean sunJaxWsBean) {
        super("Discouraged WSDL folder");
        this.m_bundle = bundle;
        this.m_newFolder = JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false);
        this.m_markerGroupUUID = markerGroupUUID;
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_webserviceEnum = WebserviceEnum.Provider;
        this.setSolutionDescription(Texts.get("DescriptionTaskMoveFiles", this.m_newFolder.getProjectRelativePath().toString()));
    }

    public DiscouragedWsdlFolderCommand(IScoutBundle bundle, String markerGroupUUID, BuildJaxWsBean buildJaxWsBean) {
        super("Discouraged WSDL folder");
        this.m_bundle = bundle;
        this.m_newFolder = JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_CONSUMER, false);
        this.m_markerGroupUUID = markerGroupUUID;
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.m_webserviceEnum = WebserviceEnum.Consumer;
        this.setSolutionDescription("By using this task, a new WSDL file is created.");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        WsFileMoveWizard wizard = new WsFileMoveWizard();
        wizard.setBundle(this.m_bundle);
        wizard.setWebserviceEnum(this.m_webserviceEnum);
        wizard.setBuildJaxWsBean(this.m_buildJaxWsBean);
        wizard.setSunJaxWsBean(this.m_sunJaxWsBean);
        wizard.setDestination(this.m_newFolder);
        wizard.setMarkerGroupUUID(this.m_markerGroupUUID);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        return wizardDialog.open() == 32;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
    }
}

