/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WsConsumerDeleteOperation
implements IOperation {
    public static final int ID_REGISTRATION = 1;
    public static final int ID_SERVICE_REGISTRATION = 2;
    public static final int ID_STUB = 4;
    public static final int ID_TYPE = 8;
    public static final int ID_BINDING_FILE = 16;
    public static final int ID_WSDL_FILE = 32;
    public static final int ID_REF_WSDL = 64;
    public static final int ID_REF_XSD = 128;
    private IScoutBundle m_bundle;
    private BuildJaxWsBean m_buildJaxWsBean;
    private List<ElementBean> m_elements;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("No bundle set");
        }
        if (this.m_elements == null) {
            throw new IllegalArgumentException("No elements set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        for (ElementBean element : this.m_elements) {
            switch (element.getId()) {
                case 1: {
                    this.deleteBuildJaxWsXmlEntry(monitor);
                    break;
                }
                case 2: {
                    this.unregisterService(this.m_bundle, (IType)element.getJavaElement(), monitor);
                    break;
                }
                case 8: {
                    this.deleteType((IType)element.getJavaElement(), monitor);
                    break;
                }
                case 4: {
                    this.deleteStubFile((IFile)element.getResource(), monitor);
                    break;
                }
                case 16: 
                case 32: 
                case 64: 
                case 128: {
                    this.deleteFile((IFile)element.getResource(), monitor);
                }
            }
        }
    }

    private void deleteBuildJaxWsXmlEntry(IProgressMonitor monitor) throws CoreException {
        if (this.m_buildJaxWsBean == null) {
            return;
        }
        String alias = this.m_buildJaxWsBean.getAlias();
        ScoutXmlDocument xmlDocument = this.m_buildJaxWsBean.getXml().getDocument();
        xmlDocument.getRoot().removeChild(this.m_buildJaxWsBean.getXml());
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(xmlDocument, 4, monitor, alias);
    }

    private void deleteType(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            type.getCompilationUnit().delete(true, monitor);
        }
        catch (Exception e) {
            JaxWsSdk.logError("could not delete type", e);
        }
    }

    private void deleteFile(IFile file, IProgressMonitor monitor) throws CoreException {
        if (file != null && file.exists()) {
            file.delete(true, true, monitor);
        }
    }

    private void deleteStubFile(IFile jarFile, IProgressMonitor monitor) throws CoreException {
        if (jarFile != null && jarFile.exists()) {
            try {
                jarFile.delete(true, true, monitor);
                JaxWsSdkUtility.registerJarLib(this.m_bundle, jarFile, true, monitor);
            }
            catch (Exception e) {
                JaxWsSdk.logError(e);
            }
        }
    }

    private void unregisterService(IScoutBundle bundle, IType type, IProgressMonitor monitor) throws CoreException {
        IScoutBundle implementationBundle = ScoutSdkCore.getScoutWorkspace().getScoutBundle(bundle.getJavaProject().getProject());
        IScoutBundle[] iScoutBundleArray = implementationBundle.getRequiredBundles(ScoutBundleFilters.getServerFilter(), true);
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle serverBundle = iScoutBundleArray[n2];
            ScoutUtility.unregisterServiceClass((IProject)serverBundle.getProject(), (String)"org.eclipse.scout.service.services", (String)"service", (String)type.getFullyQualifiedName(), (String)(String.valueOf(serverBundle.getRootPackageName()) + ".ServerSession"), (IProgressMonitor)monitor);
            ++n2;
        }
    }

    public String getOperationName() {
        return WsConsumerDeleteOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }

    public List<ElementBean> getElements() {
        return this.m_elements;
    }

    public void setElements(List<ElementBean> elements) {
        this.m_elements = elements;
    }
}

