/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import javax.xml.ws.Service;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.operation.util.ScoutTypeNewOperation;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WsConsumerImplNewOperation
extends ServiceNewOperation {
    private IType m_jaxWsServiceType;
    private IType m_jaxWsPortType;
    private boolean m_createScoutWebServiceAnnotation;
    private String m_authenticationHandlerQName;

    public void validate() throws IllegalArgumentException {
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        IType jaxWsPortType = null;
        if (TypeUtility.exists((IJavaElement)this.getJaxWsPortType())) {
            jaxWsPortType = this.getJaxWsPortType();
        } else {
            jaxWsPortType = TypeUtility.getType((String)Object.class.getName());
            JaxWsSdk.logError("Could not link webservice consumer to port type as port type could not be found");
        }
        IType jaxWsServiceType = null;
        if (TypeUtility.exists((IJavaElement)this.getJaxWsServiceType())) {
            jaxWsServiceType = this.getJaxWsServiceType();
        } else {
            jaxWsServiceType = TypeUtility.getType((String)Service.class.getName());
            JaxWsSdk.logError("Could not link webservice consumer to service as service could not be found");
        }
        String superTypeSignature = "<";
        superTypeSignature = String.valueOf(superTypeSignature) + Signature.toString((String)Signature.createTypeSignature((String)jaxWsServiceType.getFullyQualifiedName(), (boolean)true));
        superTypeSignature = String.valueOf(superTypeSignature) + ", ";
        superTypeSignature = String.valueOf(superTypeSignature) + Signature.toString((String)Signature.createTypeSignature((String)jaxWsPortType.getFullyQualifiedName(), (boolean)true));
        superTypeSignature = String.valueOf(superTypeSignature) + ">";
        superTypeSignature = Signature.createTypeSignature((String)(String.valueOf(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient").getFullyQualifiedName()) + superTypeSignature), (boolean)true);
        this.setServiceSuperTypeSignature(superTypeSignature);
        super.run(monitor, workingCopyManager);
        IType createdType = this.getCreatedServiceImplementation();
        JaxWsSdkUtility.createImportDirective(createdType, jaxWsPortType);
        JaxWsSdkUtility.createImportDirective(createdType, jaxWsServiceType);
        if (this.m_createScoutWebServiceAnnotation) {
            AnnotationUpdateOperation annotationOp = new AnnotationUpdateOperation();
            annotationOp.setDeclaringType(createdType);
            annotationOp.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient"));
            String defaultAuthFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient").getMethod("authenticationHandler", new String[0]).getDefaultValue().getValue();
            if (this.m_authenticationHandlerQName != null && !this.isSameType(this.m_authenticationHandlerQName, defaultAuthFactory)) {
                IType type = this.createType(this.m_authenticationHandlerQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler"), monitor, workingCopyManager);
                annotationOp.addTypeProperty("authenticationHandler", type);
            }
            annotationOp.validate();
            annotationOp.run(monitor, workingCopyManager);
        }
        ICompilationUnit icu = createdType.getCompilationUnit();
        Document icuDoc = new Document(icu.getBuffer().getContents());
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(createdType.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        workingCopyManager.reconcile(icu, monitor);
    }

    private IType createType(String qualifiedTypeName, IType interfaceType, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType type;
        if (TypeUtility.existsType((String)qualifiedTypeName)) {
            type = TypeUtility.getType((String)qualifiedTypeName);
        } else {
            String typeName = Signature.getSimpleName((String)qualifiedTypeName);
            String packageName = Signature.getQualifier((String)qualifiedTypeName);
            ScoutTypeNewOperation newTypeOp = new ScoutTypeNewOperation(typeName, packageName, this.getImplementationBundle());
            newTypeOp.addInterfaceSignature(Signature.createTypeSignature((String)interfaceType.getFullyQualifiedName(), (boolean)true));
            newTypeOp.run(monitor, workingCopyManager);
            type = newTypeOp.getCreatedType();
            workingCopyManager.register(type.getCompilationUnit(), monitor);
        }
        return type;
    }

    public String getOperationName() {
        return WsConsumerImplNewOperation.class.getName();
    }

    public boolean isCreateScoutWebserviceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public void setCreateScoutWebServiceAnnotation(boolean createScoutWebServiceAnnotation) {
        this.m_createScoutWebServiceAnnotation = createScoutWebServiceAnnotation;
    }

    public String getAuthenticationHandlerQName() {
        return this.m_authenticationHandlerQName;
    }

    public void setAuthenticationHandlerQName(String authenticationHandlerQName) {
        this.m_authenticationHandlerQName = authenticationHandlerQName;
    }

    public boolean isCreateScoutWebServiceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public IType getJaxWsServiceType() {
        return this.m_jaxWsServiceType;
    }

    public void setJaxWsServiceType(IType jaxWsServiceType) {
        this.m_jaxWsServiceType = jaxWsServiceType;
    }

    public IType getJaxWsPortType() {
        return this.m_jaxWsPortType;
    }

    public void setJaxWsPortType(IType jaxWsPortType) {
        this.m_jaxWsPortType = jaxWsPortType;
    }

    private boolean isSameType(String fullyQualifiedName1, String fullyQualifiedName2) {
        if (fullyQualifiedName1 != null) {
            fullyQualifiedName1 = fullyQualifiedName1.replaceAll("\\$", ".");
        }
        if (fullyQualifiedName2 != null) {
            fullyQualifiedName2 = fullyQualifiedName2.replaceAll("\\$", ".");
        }
        return CompareUtility.equals((Object)fullyQualifiedName1, (Object)fullyQualifiedName2);
    }
}

