/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.annotation.AnnotationCreateOperation;
import org.eclipse.scout.sdk.operation.method.MethodCreateOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementFormatOperation;
import org.eclipse.scout.sdk.operation.util.ScoutTypeNewOperation;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;

public class WsProviderImplNewOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_typeName;
    private String m_packageName;
    private IType m_portTypeInterfaceType;
    private boolean m_createScoutWebServiceAnnotation;
    private String m_sessionFactoryQName;
    private String m_authenticationHandlerQName;
    private String m_credentialValidationStrategyQName;
    private IType m_createdType;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (this.m_typeName == null) {
            throw new IllegalArgumentException("typeName not set");
        }
        if (this.m_packageName == null) {
            throw new IllegalArgumentException("packageName not set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        ScoutTypeNewOperation implNewTypeOp = new ScoutTypeNewOperation(this.m_typeName, this.m_packageName, this.m_bundle);
        if (TypeUtility.exists((IJavaElement)this.m_portTypeInterfaceType)) {
            implNewTypeOp.addInterfaceSignature(Signature.createTypeSignature((String)this.m_portTypeInterfaceType.getFullyQualifiedName(), (boolean)true));
        } else {
            JaxWsSdk.logError("Could not link webservice provider to port type as port type could not be found");
        }
        implNewTypeOp.run(monitor, workingCopyManager);
        this.m_createdType = implNewTypeOp.getCreatedType();
        workingCopyManager.register(this.m_createdType.getCompilationUnit(), monitor);
        if (TypeUtility.exists((IJavaElement)this.m_portTypeInterfaceType)) {
            IMethod[] iMethodArray = this.m_portTypeInterfaceType.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                MethodCreateOperation op = new MethodCreateOperation(this.m_createdType, method.getElementName());
                op.setReturnTypeSignature(SignatureUtility.getReturnTypeSignatureResolved((IMethod)method, (IType)this.m_portTypeInterfaceType));
                op.setMethodFlags(method.getFlags());
                op.setExceptionSignatures(method.getExceptionTypes());
                String[] paramNames = method.getParameterNames();
                op.setParameterNames(paramNames);
                op.setParameterSignatures(SignatureUtility.getMethodParameterSignatureResolved((IMethod)method, (IType)this.m_portTypeInterfaceType));
                op.addAnnotation(new AnnotationCreateOperation(null, Signature.createTypeSignature((String)Override.class.getName(), (boolean)true)));
                op.run(monitor, workingCopyManager);
                JavaElementFormatOperation wellFormOp = new JavaElementFormatOperation((IMember)op.getCreatedMethod(), true);
                wellFormOp.validate();
                wellFormOp.run(monitor, workingCopyManager);
                ++n2;
            }
        }
        AnnotationUpdateOperation annotationOp = new AnnotationUpdateOperation();
        annotationOp.setDeclaringType(this.m_createdType);
        annotationOp.setAnnotationType(TypeUtility.getType((String)WebService.class.getName()));
        if (TypeUtility.exists((IJavaElement)this.m_portTypeInterfaceType)) {
            annotationOp.addStringProperty("endpointInterface", this.m_portTypeInterfaceType.getFullyQualifiedName());
        }
        annotationOp.validate();
        annotationOp.run(monitor, workingCopyManager);
        if (this.m_createScoutWebServiceAnnotation) {
            IType type;
            annotationOp = new AnnotationUpdateOperation();
            annotationOp.setDeclaringType(this.m_createdType);
            annotationOp.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService"));
            String defaultSessionFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("sessionFactory", new String[0]).getDefaultValue().getValue();
            String defaultAuthFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("authenticationHandler", new String[0]).getDefaultValue().getValue();
            String defaultCredentialFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("credentialValidationStrategy", new String[0]).getDefaultValue().getValue();
            if (this.m_sessionFactoryQName != null && !this.isSameType(this.m_sessionFactoryQName, defaultSessionFactory)) {
                type = this.createType(this.m_sessionFactoryQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory"), monitor, workingCopyManager);
                annotationOp.addTypeProperty("sessionFactory", type);
            }
            if (this.m_authenticationHandlerQName != null && !this.isSameType(this.m_authenticationHandlerQName, defaultAuthFactory)) {
                type = this.createType(this.m_authenticationHandlerQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler"), monitor, workingCopyManager);
                annotationOp.addTypeProperty("authenticationHandler", type);
            }
            if (this.m_credentialValidationStrategyQName != null && !this.isSameType(this.m_credentialValidationStrategyQName, defaultCredentialFactory)) {
                type = this.createType(this.m_credentialValidationStrategyQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy"), monitor, workingCopyManager);
                annotationOp.addTypeProperty("credentialValidationStrategy", type);
            }
            annotationOp.validate();
            annotationOp.run(monitor, workingCopyManager);
        }
        ICompilationUnit icu = this.m_createdType.getCompilationUnit();
        Document icuDoc = new Document(icu.getBuffer().getContents());
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(this.m_createdType.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        workingCopyManager.reconcile(icu, monitor);
    }

    private IType createType(String qualifiedTypeName, IType interfaceType, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType type;
        if (TypeUtility.existsType((String)qualifiedTypeName)) {
            type = TypeUtility.getType((String)qualifiedTypeName);
        } else {
            String typeName = Signature.getSimpleName((String)qualifiedTypeName);
            String packageName = Signature.getQualifier((String)qualifiedTypeName);
            ScoutTypeNewOperation newTypeOp = new ScoutTypeNewOperation(typeName, packageName, this.m_bundle);
            newTypeOp.addInterfaceSignature(Signature.createTypeSignature((String)interfaceType.getFullyQualifiedName(), (boolean)true));
            newTypeOp.run(monitor, workingCopyManager);
            type = newTypeOp.getCreatedType();
            workingCopyManager.register(type.getCompilationUnit(), monitor);
        }
        return type;
    }

    public String getOperationName() {
        return WsProviderImplNewOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }

    public boolean isCreateScoutWebserviceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public void setCreateScoutWebServiceAnnotation(boolean createScoutWebServiceAnnotation) {
        this.m_createScoutWebServiceAnnotation = createScoutWebServiceAnnotation;
    }

    public String getSessionFactoryQName() {
        return this.m_sessionFactoryQName;
    }

    public void setSessionFactoryQName(String sessionFactoryQName) {
        this.m_sessionFactoryQName = sessionFactoryQName;
    }

    public String getAuthenticationHandlerQName() {
        return this.m_authenticationHandlerQName;
    }

    public void setAuthenticationHandlerQName(String authenticationHandlerQName) {
        this.m_authenticationHandlerQName = authenticationHandlerQName;
    }

    public String getCredentialValidationStrategyQName() {
        return this.m_credentialValidationStrategyQName;
    }

    public void setCredentialValidationStrategyQName(String credentialValidationStrategyQName) {
        this.m_credentialValidationStrategyQName = credentialValidationStrategyQName;
    }

    public boolean isCreateScoutWebServiceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public void setCreatedType(IType createdType) {
        this.m_createdType = createdType;
    }

    public IType getCreatedType() {
        return this.m_createdType;
    }

    public IType getPortTypeInterfaceType() {
        return this.m_portTypeInterfaceType;
    }

    public void setPortTypeInterfaceType(IType portTypeInterfaceType) {
        this.m_portTypeInterfaceType = portTypeInterfaceType;
    }

    private boolean isSameType(String fullyQualifiedName1, String fullyQualifiedName2) {
        if (fullyQualifiedName1 != null) {
            fullyQualifiedName1 = fullyQualifiedName1.replaceAll("\\$", ".");
        }
        if (fullyQualifiedName2 != null) {
            fullyQualifiedName2 = fullyQualifiedName2.replaceAll("\\$", ".");
        }
        return CompareUtility.equals((Object)fullyQualifiedName1, (Object)fullyQualifiedName2);
    }
}

