/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPresenterValueChangedListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class HandlerPresenter
extends TypePresenter {
    private SunJaxWsBean m_sunJaxWsBean;
    private ScoutXmlDocument.ScoutXmlElement m_xmlHandlerElement;
    private IPresenterValueChangedListener m_valueChangedListener;
    private int m_handlerIndex;
    private int m_handlerCount;

    public HandlerPresenter(IScoutBundle bundle, Composite parent, int handlerIndex, int handlerCount, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit, 70, false);
        this.m_handlerIndex = handlerIndex;
        this.m_handlerCount = handlerCount;
        this.setMarkerType(JaxWsConstants.MarkerType.HandlerClass);
        this.setBundle(bundle);
        this.setAcceptNullValue(false);
        this.setUseLinkAsLabel(true);
        this.setAllowChangeOfInterfaceType(false);
        this.setAllowChangeOfSourceFolder(false);
        this.setResetLinkVisible(true);
        this.setResetTooltip(Texts.get("TooltipRemoveHandlerRegistration"));
        this.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedHandlerPackageName(this.m_bundle));
        this.m_valueChangedListener = new P_ValueChangedListener();
        this.addValueChangedListener(this.m_valueChangedListener);
        String interfaceSignature = Signature.createTypeSignature((String)(String.valueOf(SOAPHandler.class.getName()) + "<" + SOAPMessageContext.class.getName() + ">"), (boolean)false);
        IType interfaceType = TypeUtility.getTypeBySignature((String)interfaceSignature);
        this.setInterfaceSignatures(new String[]{interfaceSignature});
        this.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(interfaceType));
        this.callInitializer();
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite composite = this.getToolkit().createComposite(parent, 0);
        Control content = super.createContent(composite);
        ImageHyperlink upButton = this.getToolkit().createImageHyperlink(composite, 0);
        upButton.setImage(JaxWsSdk.getImage("arrow_up.gif"));
        upButton.setToolTipText(Texts.get("ClickToIncreasePrecendence"));
        upButton.setEnabled(this.m_handlerIndex > 0);
        upButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ScoutXmlDocument.ScoutXmlElement xmlChain = HandlerPresenter.this.m_xmlHandlerElement.getParent();
                if (HandlerPresenter.this.m_sunJaxWsBean.swapHandler(xmlChain, HandlerPresenter.this.m_handlerIndex, HandlerPresenter.this.m_handlerIndex - 1)) {
                    ResourceFactory.getSunJaxWsResource(HandlerPresenter.this.m_bundle).storeXmlAsync(HandlerPresenter.this.m_sunJaxWsBean.getXml().getDocument(), 512, HandlerPresenter.this.m_sunJaxWsBean.getAlias());
                }
            }
        });
        ImageHyperlink downButton = this.getToolkit().createImageHyperlink(composite, 0);
        downButton.setImage(JaxWsSdk.getImage("arrow_down.gif"));
        downButton.setToolTipText(Texts.get("ClickToLowerPrecendence"));
        downButton.setEnabled(this.m_handlerIndex < this.m_handlerCount - 1);
        downButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ScoutXmlDocument.ScoutXmlElement xmlChain = HandlerPresenter.this.m_xmlHandlerElement.getParent();
                if (HandlerPresenter.this.m_sunJaxWsBean.swapHandler(xmlChain, HandlerPresenter.this.m_handlerIndex, HandlerPresenter.this.m_handlerIndex + 1)) {
                    ResourceFactory.getSunJaxWsResource(HandlerPresenter.this.m_bundle).storeXmlAsync(HandlerPresenter.this.m_sunJaxWsBean.getXml().getDocument(), 512, HandlerPresenter.this.m_sunJaxWsBean.getAlias());
                }
            }
        });
        composite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)upButton, -2, 16384);
        content.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(2, 0);
        formData.right = new FormAttachment(100, 0);
        upButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 12);
        formData.right = new FormAttachment(100, 0);
        downButton.setLayoutData((Object)formData);
        return composite;
    }

    @Override
    public void dispose() {
        if (this.m_valueChangedListener != null) {
            this.removeValueChangedListener(this.m_valueChangedListener);
            this.m_valueChangedListener = null;
        }
        super.dispose();
    }

    @Override
    protected void execResetAction() throws CoreException {
        this.m_xmlHandlerElement.getParent().removeChild(this.m_xmlHandlerElement);
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXmlAsync(this.m_sunJaxWsBean.getXml().getDocument(), 512, this.m_sunJaxWsBean.getAlias());
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }

    public ScoutXmlDocument.ScoutXmlElement getXmlHandlerElement() {
        return this.m_xmlHandlerElement;
    }

    public void setXmlHandlerElement(ScoutXmlDocument.ScoutXmlElement xmlHandlerElement) {
        this.m_xmlHandlerElement = xmlHandlerElement;
    }

    private TypePresenter.ISearchJavaSearchScopeFactory createSubClassesSearchScopeFactory(final IType superType) {
        return new TypePresenter.ISearchJavaSearchScopeFactory(){

            @Override
            public IJavaSearchScope create() {
                IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(HandlerPresenter.this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
                return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
            }
        };
    }

    private void updateTransactionalIcon(String fqn) {
        IAnnotation annotation;
        IType type = TypeUtility.getType((String)fqn);
        ImageDescriptor icon = null;
        String tooltip = null;
        if (TypeUtility.exists((IJavaElement)type) && (annotation = JaxWsSdkUtility.getAnnotation(type, TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutTransaction").getFullyQualifiedName(), false)) != null) {
            icon = JaxWsSdk.getImageDescriptor("repository-synchronize.gif");
            AnnotationProperty prop = JaxWsSdkUtility.parseAnnotationTypeValue(type, annotation, "sessionFactory");
            tooltip = "This is a transactional handler\nServer session factory: " + Signature.getSimpleName((String)prop.getFullyQualifiedName());
        }
        this.setIconImageDescriptor(icon);
        this.setIconTooltip(tooltip);
    }

    @Override
    public void updateInfo() {
        this.updateTransactionalIcon((String)this.getValue());
        super.updateInfo();
    }

    private class P_ValueChangedListener
    implements IPresenterValueChangedListener {
        private P_ValueChangedListener() {
        }

        @Override
        public void propertyChanged(int presenterId, Object value) {
            String fqn = (String)value;
            String handlerClassElementName = HandlerPresenter.this.m_sunJaxWsBean.toQualifiedName("handler-class");
            HandlerPresenter.this.m_xmlHandlerElement.removeChild(handlerClassElementName);
            ScoutXmlDocument.ScoutXmlElement child = HandlerPresenter.this.m_xmlHandlerElement.addChild();
            child.setName(handlerClassElementName);
            child.addText(fqn);
            HandlerPresenter.this.updateTransactionalIcon(fqn);
            ResourceFactory.getSunJaxWsResource(HandlerPresenter.this.m_bundle).storeXmlAsync(HandlerPresenter.this.m_sunJaxWsBean.getXml().getDocument(), 512, HandlerPresenter.this.m_sunJaxWsBean.getAlias());
        }
    }
}

