/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsFilesMoveOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ResourceSelectionWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtefactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaArtefactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;

public class WsFileMoveWizard
extends AbstractWorkspaceWizard {
    private ResourceSelectionWizardPage m_wizardPage;
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;
    private WebserviceEnum m_webserviceEnum;
    private IFolder m_destination;
    private String m_markerGroupUUID;
    private WsFilesMoveOperation m_operation;

    public WsFileMoveWizard() {
        this.setWindowTitle(Texts.get("MovingFiles"));
    }

    public void addPages() {
        this.m_wizardPage = new ResourceSelectionWizardPage(Texts.get("QuestionMoveFiles", this.m_destination.getProjectRelativePath().toString()), Texts.get("QuestionMove"));
        this.m_wizardPage.setElements(this.getElementsToBeMoved());
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    private List<ElementBean> getElementsToBeMoved() {
        IFile[] bindingFiles;
        final LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        IFile wsdlFile = null;
        if (this.m_webserviceEnum == WebserviceEnum.Provider) {
            if (this.m_sunJaxWsBean != null && StringUtility.hasText((String)this.m_sunJaxWsBean.getWsdl())) {
                wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, (IPath)new Path(this.m_sunJaxWsBean.getWsdl()), false);
            }
        } else if (this.m_buildJaxWsBean != null && StringUtility.hasText((String)this.m_buildJaxWsBean.getWsdl())) {
            wsdlFile = JaxWsSdkUtility.getFile(this.m_bundle, (IPath)new Path(this.m_buildJaxWsBean.getWsdl()), false);
        }
        if (wsdlFile == null || !wsdlFile.exists()) {
            return elements;
        }
        if (this.m_webserviceEnum == WebserviceEnum.Provider) {
            elements.add(new ElementBean(16, String.format("Change WSDL file registration in sun-jaxws.xml to '%s'", this.m_destination.getProjectRelativePath().append(wsdlFile.getName())), JaxWsSdk.getImageDescriptor("sunJaxWs.png"), true));
        } else {
            elements.add(new ElementBean(32, String.format("Change WSDL file registration in build-jaxws.xml to '%'", this.m_destination.getProjectRelativePath().append(wsdlFile.getName())), JaxWsSdk.getImageDescriptor("build-jaxws.png"), true));
        }
        elements.add(new ElementBean(2, Texts.get("MoveXToY", "WSDL file", this.m_destination.getProjectRelativePath().append(wsdlFile.getName()).toString()), JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)wsdlFile, true));
        SchemaUtility.visitArtefacts(wsdlFile, (ISchemaArtefactVisitor<IFile>)new SchemaArtefactVisitor<IFile>(){

            @Override
            public void onReferencedWsdlArtefact(SchemaUtility.WsdlArtefact<IFile> wsdlArtefact) {
                IFileHandle fileHandle = wsdlArtefact.getFileHandle();
                if (fileHandle != null && fileHandle.exists()) {
                    elements.add(new ElementBean(4, Texts.get("MoveReferencedXToY", "WSDL file", WsFileMoveWizard.this.m_destination.getProjectRelativePath().append(fileHandle.getName()).toString()), JaxWsSdk.getImageDescriptor("wsdl_file_obj.gif"), (IResource)fileHandle.getFile(), false));
                }
            }

            @Override
            public void onSchemaIncludeArtefact(SchemaUtility.SchemaIncludeArtefact<IFile> schemaIncludeArtefact) {
                IFileHandle fileHandle = schemaIncludeArtefact.getFileHandle();
                if (fileHandle != null && fileHandle.exists()) {
                    elements.add(new ElementBean(8, Texts.get("MoveReferencedXToY", "XSD schema (included)", WsFileMoveWizard.this.m_destination.getProjectRelativePath().append(fileHandle.getName()).toString()), JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)fileHandle.getFile(), false));
                }
            }

            @Override
            public void onSchemaImportArtefact(SchemaUtility.SchemaImportArtefact<IFile> schemaImportArtefact) {
                IFileHandle fileHandle = schemaImportArtefact.getFileHandle();
                if (fileHandle != null && fileHandle.exists()) {
                    elements.add(new ElementBean(8, Texts.get("MoveReferencedXToY", "XSD schema (imported)", WsFileMoveWizard.this.m_destination.getProjectRelativePath().append(fileHandle.getName()).toString()), JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)fileHandle.getFile(), false));
                }
            }
        });
        IFile[] iFileArray = bindingFiles = JaxWsSdkUtility.getBindingFiles(this.m_bundle, this.m_buildJaxWsBean.getPropertiers());
        int n = bindingFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile bindingFile = iFileArray[n2];
            XmlResource xmlResource = new XmlResource(this.m_bundle);
            xmlResource.setFile(bindingFile);
            ScoutXmlDocument xmlDocument = xmlResource.loadXml();
            String namespacePrefix = xmlDocument.getRoot().getNamePrefix();
            ScoutXmlDocument.ScoutXmlElement xmlBindings = xmlDocument.getChild(StringUtility.join((String)":", (Object[])new Object[]{namespacePrefix, "bindings"}));
            if (xmlBindings != null && xmlBindings.hasAttribute("wsdlLocation")) {
                String wsdlLocation = xmlBindings.getAttribute("wsdlLocation");
                String schemaDefiningFileName = new Path(wsdlLocation).toFile().getName();
                IPath relativeWsdlFolderPath = this.m_destination.getProjectRelativePath().makeRelativeTo(JaxWsSdkUtility.getParentFolder(this.m_bundle, bindingFile).getProjectRelativePath());
                String newWsdlLocation = PathNormalizer.toWsdlPath(relativeWsdlFolderPath.append(schemaDefiningFileName).toString());
                ElementBean elementBean = new ElementBean(64, "Change attribute 'wsdlLocation' in binding file '" + bindingFile.getName() + "' to '" + newWsdlLocation + "'", JaxWsSdk.getImageDescriptor("xsdFile.gif"), (IResource)bindingFile, false);
                elementBean.setData(newWsdlLocation);
                elements.add(elementBean);
            }
            ++n2;
        }
        return elements;
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_operation = new WsFilesMoveOperation();
        this.m_operation.setBundle(this.m_bundle);
        this.m_operation.setBuildJaxWsBean(this.m_buildJaxWsBean);
        this.m_operation.setSunJaxWsBean(this.m_sunJaxWsBean);
        this.m_operation.setDestination(this.m_destination);
        LinkedList<ElementBean> elements = new LinkedList<ElementBean>();
        for (ElementBean element : this.m_wizardPage.getElements()) {
            if (!element.isChecked() && !element.isMandatory()) continue;
            elements.add(element);
        }
        this.m_operation.setElements(elements);
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        this.m_operation.run(monitor, workingCopyManager);
        if (this.m_webserviceEnum == WebserviceEnum.Provider) {
            JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, this.m_markerGroupUUID, 44);
        } else {
            JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, this.m_markerGroupUUID, 7);
        }
        return true;
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }

    public WebserviceEnum getWebserviceEnum() {
        return this.m_webserviceEnum;
    }

    public void setWebserviceEnum(WebserviceEnum webserviceEnum) {
        this.m_webserviceEnum = webserviceEnum;
    }

    public IFolder getDestination() {
        return this.m_destination;
    }

    public void setDestination(IFolder destination) {
        this.m_destination = destination;
    }

    public String getMarkerGroupUUID() {
        return this.m_markerGroupUUID;
    }

    public void setMarkerGroupUUID(String markerGroupUUID) {
        this.m_markerGroupUUID = markerGroupUUID;
    }
}

