/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.util.ServletRegistrationUtility;
import org.eclipse.scout.sdk.ws.jaxws.validator.IServletAliasValidation;
import org.eclipse.scout.sdk.ws.jaxws.validator.IUrlPatternValidation;
import org.eclipse.scout.sdk.ws.jaxws.validator.ServletAliasValidator;
import org.eclipse.scout.sdk.ws.jaxws.validator.UrlPatternValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JaxWsServletRegistrationWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_REGISTRATION_BUNDLE = "registrationBundle";
    public static final String PROP_ALIAS = "alias";
    public static final String PROP_URL_PATTERN = "urlPattern";
    private BasicPropertySupport m_propertySupport;
    private ProposalTextField m_registrationBundleField;
    private StyledTextField m_aliasField;
    private Composite m_descriptionContainer;
    private Text m_descriptionField;
    private StyledTextField m_urlPatternField;
    private IScoutBundle m_bundle;
    private IScoutBundle[] m_candidateBundles;
    private Map<IScoutBundle, String> m_servletRegistrationAliasMap;
    private boolean m_urlPatternVisible;

    public JaxWsServletRegistrationWizardPage(IScoutBundle bundle, boolean urlPatternVisible) {
        super(JaxWsServletRegistrationWizardPage.class.getName());
        ServletRegistrationUtility.Registration[] registrations;
        this.setDescription(Texts.get("DescriptionJaxWsBundleConfiguration"));
        this.m_urlPatternVisible = urlPatternVisible;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_bundle = bundle;
        this.m_candidateBundles = ServletRegistrationUtility.getJaxWsBundlesOnClasspath(this.m_bundle);
        this.m_servletRegistrationAliasMap = new HashMap<IScoutBundle, String>();
        ServletRegistrationUtility.Registration[] registrationArray = registrations = ServletRegistrationUtility.getJaxWsServletRegistrationsOnClasspath(this.m_bundle);
        int n = registrations.length;
        int n2 = 0;
        while (n2 < n) {
            ServletRegistrationUtility.Registration registration = registrationArray[n2];
            this.m_servletRegistrationAliasMap.put(registration.getBundle(), registration.getAlias());
            ++n2;
        }
    }

    protected void createContent(Composite parent) {
        this.m_registrationBundleField = this.getFieldToolkit().createProposalField(parent, Texts.get("ServletRegistrationBundle"));
        this.m_registrationBundleField.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        SimpleProposal[] proposals = new SimpleProposal[this.m_candidateBundles.length];
        int i = 0;
        while (i < proposals.length) {
            proposals[i] = new P_BundleProposal(this.m_candidateBundles[i]);
            ++i;
        }
        this.m_registrationBundleField.setContentProvider((IContentProvider)new SimpleProposalProvider(proposals));
        this.m_registrationBundleField.addProposalAdapterListener(new IProposalAdapterListener(){

            public void proposalAccepted(ContentProposalEvent event) {
                Object proposal = event.proposal;
                if (proposal != null) {
                    IScoutBundle registrationBundle = ((P_BundleProposal)((Object)proposal)).getBundle();
                    JaxWsServletRegistrationWizardPage.this.setRegistrationBundleInternal(registrationBundle);
                    if (JaxWsServletRegistrationWizardPage.this.m_servletRegistrationAliasMap.containsKey(registrationBundle)) {
                        JaxWsServletRegistrationWizardPage.this.m_aliasField.setEnabled(registrationBundle.getBundleName().equals(JaxWsServletRegistrationWizardPage.this.getBundle().getBundleName()) || !StringUtility.hasText((String)((String)JaxWsServletRegistrationWizardPage.this.m_servletRegistrationAliasMap.get(registrationBundle))));
                        JaxWsServletRegistrationWizardPage.this.setAlias(StringUtility.nvl(JaxWsServletRegistrationWizardPage.this.m_servletRegistrationAliasMap.get(registrationBundle), (String)"/jaxws"));
                    } else {
                        JaxWsServletRegistrationWizardPage.this.m_aliasField.setEnabled(true);
                        JaxWsServletRegistrationWizardPage.this.setAlias("/jaxws");
                    }
                } else {
                    JaxWsServletRegistrationWizardPage.this.setRegistrationBundleInternal(null);
                }
                JaxWsServletRegistrationWizardPage.this.pingStateChanging();
            }
        });
        this.m_aliasField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("ServletAlias"));
        this.m_aliasField.setReadOnlyPrefix("/");
        this.m_aliasField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JaxWsServletRegistrationWizardPage.this.setAliasInternal(JaxWsServletRegistrationWizardPage.this.m_aliasField.getText());
                JaxWsServletRegistrationWizardPage.this.m_urlPatternField.setReadOnlyPrefix(new Path(PathNormalizer.toServletAlias(JaxWsServletRegistrationWizardPage.this.m_aliasField.getText())).addTrailingSeparator().toString());
                JaxWsServletRegistrationWizardPage.this.pingStateChanging();
            }
        });
        this.m_descriptionContainer = new Composite(parent, 0);
        this.m_descriptionField = new Text(this.m_descriptionContainer, 74);
        this.m_descriptionField.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionField.setText(Texts.get("DescriptionChangeJaxWsServletAlias"));
        this.m_urlPatternField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("UrlPattern"));
        this.m_urlPatternField.setReadOnlyPrefix(new Path(PathNormalizer.toServletAlias(StringUtility.emptyIfNull((Object)this.getAlias()))).addTrailingSeparator().toString());
        this.m_urlPatternField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JaxWsServletRegistrationWizardPage.this.setUrlPatternInternal(JaxWsServletRegistrationWizardPage.this.m_urlPatternField.getText());
                JaxWsServletRegistrationWizardPage.this.pingStateChanging();
            }
        });
        this.m_urlPatternField.setText(StringUtility.emptyIfNull((Object)this.getUrlPattern()));
        IScoutBundle registrationBundle = this.getRegistrationBundle();
        if (registrationBundle != null) {
            this.m_registrationBundleField.acceptProposal((Object)new P_BundleProposal(registrationBundle));
        }
        this.m_aliasField.setText(StringUtility.emptyIfNull((Object)this.getAlias()));
        parent.setLayout((Layout)new GridLayout(1, true));
        boolean excludeBundleRegistration = this.m_candidateBundles.length <= 1;
        GridData gd = new GridData(768);
        gd.exclude = excludeBundleRegistration;
        this.m_registrationBundleField.setVisible(!excludeBundleRegistration);
        this.m_registrationBundleField.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.m_aliasField.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.m_descriptionContainer.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.exclude = !this.m_urlPatternVisible;
        gd.verticalIndent = 15;
        this.m_urlPatternField.setLayoutData((Object)gd);
        this.m_descriptionContainer.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionField.setLayoutData((Object)formData);
    }

    public void initializeDefaultValues(IScoutBundle bundle) {
        ServletRegistrationUtility.Registration registration = ServletRegistrationUtility.getServletRegistration(this.m_bundle);
        if (registration == null || StringUtility.isNullOrEmpty((String)registration.getAlias())) {
            ServletRegistrationUtility.Registration[] candidateRegistrations = ServletRegistrationUtility.getJaxWsServletRegistrationsOnClasspath(this.m_bundle);
            IScoutBundle[] candidateBundles = ServletRegistrationUtility.getJaxWsBundlesOnClasspath(this.m_bundle);
            if (candidateRegistrations.length > 0) {
                ServletRegistrationUtility.Registration candidateRegistration = candidateRegistrations[0];
                this.setRegistrationBundle(candidateRegistration.getBundle());
                this.setAlias(candidateRegistration.getAlias());
            } else if (candidateBundles.length > 0) {
                this.setRegistrationBundle(candidateBundles[0]);
                this.setAlias("/jaxws");
            } else {
                this.setAlias("/jaxws");
            }
        } else {
            this.setAlias(registration.getAlias());
            this.setRegistrationBundle(registration.getBundle());
        }
    }

    protected void validatePage(final MultiStatus multiStatus) {
        if (!this.isControlCreated()) {
            return;
        }
        if (this.getRegistrationBundle() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "Please choose the bundle to contain the JAX-WS servlet registration"));
            return;
        }
        final String servletAlias = this.getAlias();
        boolean validationResult = ServletAliasValidator.validate(servletAlias, new IServletAliasValidation(){

            @Override
            public void onEmpty() {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("EnterJaxWsAlias")));
            }

            @Override
            public void onWrongSeparators() {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "Invalid servlet alias '" + servletAlias + "'. Must start with a slash with no empty segments and no trailing slash."));
            }

            @Override
            public void onIllegalCharacters() {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidServletAliasX", servletAlias)));
            }
        });
        if (!validationResult) {
            return;
        }
        ServletRegistrationUtility.Registration[] registrationArray = ServletRegistrationUtility.getJaxWsServletRegistrationsOnClasspath(this.m_bundle);
        int n = registrationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletRegistrationUtility.Registration registration = registrationArray[n2];
            if (!CompareUtility.equals((Object)this.getRegistrationBundle().getBundleName(), (Object)registration.getBundle().getBundleName()) && CompareUtility.equals((Object)registration.getAlias(), (Object)this.getAlias())) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "There already exists a JAX-WS servlet registration with the given alias in the bundle '" + registration.getBundle().getBundleName() + "'.\nPlease choose this bundle or another alias."));
                return;
            }
            ++n2;
        }
        if (this.m_urlPatternVisible) {
            final String urlPattern = this.getUrlPattern();
            UrlPatternValidator.validate(urlPattern, servletAlias, new IUrlPatternValidation(){

                @Override
                public void onEmpty() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", JaxWsServletRegistrationWizardPage.this.m_urlPatternField.getLabelText())));
                }

                @Override
                public void onIllegalCharacters() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidUrlX", urlPattern)));
                }

                @Override
                public void onWrongSeparators() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "Invalid URL pattern '" + urlPattern + "'. Must start with a slash with no empty segments and no trailing slash."));
                }

                @Override
                public void onNotStartingWithServletAlias() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XshouldStartWithY", JaxWsServletRegistrationWizardPage.this.m_urlPatternField.getLabelText(), servletAlias)));
                }
            });
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public IScoutBundle getRegistrationBundle() {
        return (IScoutBundle)this.m_propertySupport.getProperty(PROP_REGISTRATION_BUNDLE);
    }

    public void setRegistrationBundle(IScoutBundle registrationBundle) {
        try {
            this.setStateChanging(true);
            this.setRegistrationBundleInternal(registrationBundle);
            if (this.isControlCreated()) {
                if (registrationBundle != null) {
                    this.m_registrationBundleField.acceptProposal((Object)new P_BundleProposal(registrationBundle));
                } else {
                    this.m_registrationBundleField.acceptProposal(null);
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setRegistrationBundleInternal(IScoutBundle registrationBundle) {
        this.m_propertySupport.setProperty(PROP_REGISTRATION_BUNDLE, (Object)registrationBundle);
    }

    public void setAlias(String alias) {
        try {
            this.setStateChanging(true);
            this.setAliasInternal(alias);
            if (this.isControlCreated()) {
                String servletAlias = StringUtility.nvl((Object)PathNormalizer.toServletAlias(alias), (String)"");
                this.m_aliasField.setText(servletAlias);
                this.m_urlPatternField.setReadOnlyPrefix(new Path(servletAlias).addTrailingSeparator().toString());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAliasInternal(String alias) {
        this.m_propertySupport.setPropertyString(PROP_ALIAS, alias);
    }

    public String getAlias() {
        return this.m_propertySupport.getPropertyString(PROP_ALIAS);
    }

    public void setUrlPattern(String urlPattern) {
        try {
            this.setStateChanging(true);
            this.setUrlPatternInternal(urlPattern);
            if (this.isControlCreated()) {
                this.m_aliasField.setText(StringUtility.nvl((Object)urlPattern, (String)""));
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUrlPatternInternal(String urlPattern) {
        this.m_propertySupport.setPropertyString(PROP_URL_PATTERN, urlPattern);
    }

    public String getUrlPattern() {
        return this.m_propertySupport.getPropertyString(PROP_URL_PATTERN);
    }

    private class P_BundleProposal
    extends SimpleProposal {
        private static final String DATA_BUNDLE = "dataBundle";

        private P_BundleProposal(IScoutBundle bundle) {
            super(bundle.getBundleName(), ScoutSdkUi.getImage((String)"serverBundle.png"));
            this.setData(DATA_BUNDLE, bundle);
        }

        public IScoutBundle getBundle() {
            return (IScoutBundle)this.getData(DATA_BUNDLE);
        }
    }
}

