/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsdlStyleEnum;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.validator.IUrlPatternValidation;
import org.eclipse.scout.sdk.ws.jaxws.validator.UrlPatternValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WsPropertiesNewWsdlWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_WSDL_NAME = "wsdlName";
    public static final String PROP_DERIVE_OTHER_NAME = "deriveOtherNames";
    public static final String PROP_ALIAS = "alias";
    public static final String PROP_URL_PATTERN = "urlPattern";
    public static final String PROP_TARGET_NAMESPACE = "targetNamespace";
    public static final String PROP_SERVICE_NAME = "serviceName";
    public static final String PROP_PORT_NAME = "port";
    public static final String PROP_BINDING_NAME = "bindingName";
    public static final String PROP_PORT_TYPE_NAME = "portTypeName";
    public static final String PROP_SERVICE_OPERATION_NAME = "serviceOperationName";
    public static final String PROP_WSDL_STYLE = "wsdlStyle";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private String m_jaxWsServletAlias;
    private StyledTextField m_wsdlNameField;
    private Button m_deriveOtherNameButton;
    private StyledTextField m_alias;
    private StyledTextField m_urlPattern;
    private StyledTextField m_targetNamespaceField;
    private StyledTextField m_serviceNameField;
    private StyledTextField m_portNameField;
    private StyledTextField m_bindingNameField;
    private StyledTextField m_portTypeNameField;
    private StyledTextField m_serviceOperationNameField;
    private Composite m_wsdlStyleRadioComposite;
    private List<Button> m_wsdlStyleRadioButtons;
    private ScoutXmlDocument m_sunJaxWsXml;
    private Set<String> m_illegalAliasNames;
    private Set<String> m_illegalUrlPatterns;
    private boolean m_showOnlyWsdlProperties;

    public WsPropertiesNewWsdlWizardPage(IScoutBundle bundle) {
        super(WsPropertiesNewWsdlWizardPage.class.getName());
        this.setTitle(Texts.get("ConfigureWebserviceProperties"));
        this.setDescription(Texts.get("ConfigureWebserviceProperties"));
        this.m_bundle = bundle;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_sunJaxWsXml = ResourceFactory.getSunJaxWsResource(bundle).loadXml();
        this.m_wsdlStyleRadioButtons = new LinkedList<Button>();
        this.m_jaxWsServletAlias = "/jaxws";
        this.loadIllegalValues();
        this.applyDefaults();
    }

    private void applyDefaults() {
        this.setDeriveOtherNames(true);
        this.setWsdlStyle(WsdlStyleEnum.DocumentLiteralWrapped);
    }

    public void postActivate() {
        if (this.isShowOnlyWsdlProperties()) {
            this.deriveOtherNames();
        }
    }

    protected void createContent(Composite parent) {
        this.m_wsdlNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("WsdlName"));
        this.m_wsdlNameField.setText(this.getWsdlName());
        this.m_wsdlNameField.setReadOnlySuffix("WebService.wsdl");
        this.m_wsdlNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setWsdlNameInternal(WsPropertiesNewWsdlWizardPage.this.m_wsdlNameField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
                WsPropertiesNewWsdlWizardPage.this.deriveOtherNames();
            }
        });
        this.m_wsdlNameField.setVisible(!this.isShowOnlyWsdlProperties());
        this.m_deriveOtherNameButton = new Button(parent, 32);
        this.m_deriveOtherNameButton.setSelection(this.isDeriveOtherNames());
        this.m_deriveOtherNameButton.setText(Texts.get("DeriveOtherNamesFormWsdlFileName"));
        this.m_deriveOtherNameButton.setVisible(!this.isShowOnlyWsdlProperties());
        this.m_deriveOtherNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setDeriveOtherNames(WsPropertiesNewWsdlWizardPage.this.m_deriveOtherNameButton.getSelection());
                WsPropertiesNewWsdlWizardPage.this.deriveOtherNames();
            }
        });
        this.m_alias = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Alias"));
        this.m_alias.setText(this.getWsdlName());
        this.m_alias.setVisible(!this.isShowOnlyWsdlProperties());
        this.m_alias.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setAliasInternal(WsPropertiesNewWsdlWizardPage.this.m_alias.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_urlPattern = this.getFieldToolkit().createStyledTextField(parent, Texts.get("UrlPattern"));
        this.m_urlPattern.setText(this.getWsdlName());
        this.m_urlPattern.setReadOnlyPrefix(new Path(PathNormalizer.toServletAlias(this.m_jaxWsServletAlias)).addTrailingSeparator().toString());
        this.m_urlPattern.setVisible(!this.isShowOnlyWsdlProperties());
        this.m_urlPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setUrlPatternInternal(WsPropertiesNewWsdlWizardPage.this.m_urlPattern.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_targetNamespaceField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("TargetNamespace"));
        this.m_targetNamespaceField.setText(this.getTargetNamespace());
        this.m_targetNamespaceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setTargetNamespaceInternal(WsPropertiesNewWsdlWizardPage.this.m_targetNamespaceField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_serviceNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Service"));
        this.m_serviceNameField.setText(this.getServiceName());
        this.m_serviceNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setServiceNameInternal(WsPropertiesNewWsdlWizardPage.this.m_serviceNameField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_portNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Port"));
        this.m_portNameField.setText(this.getServiceName());
        this.m_portNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setPortNameInternal(WsPropertiesNewWsdlWizardPage.this.m_portNameField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_bindingNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Binding"));
        this.m_bindingNameField.setText(this.getBinding());
        this.m_bindingNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setBindingNameInternal(WsPropertiesNewWsdlWizardPage.this.m_bindingNameField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_portTypeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("PortType"));
        this.m_portTypeNameField.setText(this.getPortTypeName());
        this.m_portTypeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setPortTypeNameInternal(WsPropertiesNewWsdlWizardPage.this.m_portTypeNameField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_serviceOperationNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("ServiceOperation"));
        this.m_serviceOperationNameField.setText(this.getPortTypeName());
        this.m_serviceOperationNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsPropertiesNewWsdlWizardPage.this.setServiceOperationNameInternal(WsPropertiesNewWsdlWizardPage.this.m_serviceOperationNameField.getText());
                WsPropertiesNewWsdlWizardPage.this.pingStateChanging();
            }
        });
        Label wsdlStyleLabel = new Label(parent, 0);
        wsdlStyleLabel.setText(Texts.get("WsdlStyle"));
        this.m_wsdlStyleRadioComposite = new Composite(parent, 0);
        this.m_wsdlStyleRadioComposite.setLayout((Layout)new GridLayout(1, true));
        WsdlStyleEnum[] wsdlStyleEnumArray = WsdlStyleEnum.values();
        int n = wsdlStyleEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            WsdlStyleEnum wsdlStyleEnum = wsdlStyleEnumArray[n2];
            this.createWsdlStyleRadioButton(wsdlStyleEnum);
            ++n2;
        }
        parent.setLayout((Layout)new FormLayout());
        StyledTextField previousWidget = null;
        if (!this.isShowOnlyWsdlProperties()) {
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.m_wsdlNameField.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_wsdlNameField, 5, 1024);
            formData.left = new FormAttachment(40, 5);
            formData.right = new FormAttachment(100, 0);
            this.m_deriveOtherNameButton.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_deriveOtherNameButton, 20, 1024);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.m_alias.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_alias, 5, 1024);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.m_urlPattern.setLayoutData((Object)formData);
            previousWidget = this.m_urlPattern;
        }
        FormData formData = new FormData();
        formData.top = this.isShowOnlyWsdlProperties() ? new FormAttachment(0, 0) : new FormAttachment(previousWidget, 30, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_targetNamespaceField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_targetNamespaceField, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_serviceNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_serviceNameField, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_portNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_portNameField, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_bindingNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_bindingNameField, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_portTypeNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_portTypeNameField, 30, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_serviceOperationNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_serviceOperationNameField, 30, 1024);
        formData.right = new FormAttachment(40, 0);
        wsdlStyleLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)wsdlStyleLabel, -5, 128);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_wsdlStyleRadioComposite.setLayoutData((Object)formData);
    }

    protected void createWsdlStyleRadioButton(WsdlStyleEnum wsdlStyleEnum) {
        Button button = new Button(this.m_wsdlStyleRadioComposite, 16);
        button.setData("ID", (Object)wsdlStyleEnum);
        button.setText(wsdlStyleEnum.getLabel());
        button.setSelection(wsdlStyleEnum == this.getWsdlStyle());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WsPropertiesNewWsdlWizardPage.this.setStateChanging(true);
                    WsPropertiesNewWsdlWizardPage.this.setWsdlStyle((WsdlStyleEnum)((Object)e.widget.getData("ID")));
                }
                finally {
                    WsPropertiesNewWsdlWizardPage.this.setStateChanging(false);
                }
            }
        });
        button.setLayoutData((Object)new GridData(768));
        this.m_wsdlStyleRadioButtons.add(button);
    }

    protected void validatePage(final MultiStatus multiStatus) {
        IStatus validationStatus;
        if (!this.isControlCreated()) {
            return;
        }
        if (!this.isShowOnlyWsdlProperties()) {
            if (StringUtility.isNullOrEmpty((String)this.getWsdlName())) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_wsdlNameField.getLabelText())));
            }
            validationStatus = this.m_bundle.getProject().getWorkspace().validateName(this.getWsdlName(), 1);
            multiStatus.add(validationStatus);
            if (StringUtility.isNullOrEmpty((String)this.getAlias())) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_alias.getLabelText())));
            } else if (this.m_illegalAliasNames.contains(this.getAlias())) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XWithYDoesAlreadyExist", this.m_alias.getLabelText(), this.getAlias())));
            } else {
                IStatus status = this.m_bundle.getProject().getWorkspace().validateName(this.getAlias(), 1);
                if (!status.isOK()) {
                    multiStatus.add(status);
                }
            }
            final String urlPattern = this.getUrlPattern();
            UrlPatternValidator.validate(urlPattern, this.m_jaxWsServletAlias, new IUrlPatternValidation(){

                @Override
                public void onWrongSeparators() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "Invalid URL pattern '" + urlPattern + "'. Must start with a slash with no empty segments and no trailing slash."));
                }

                @Override
                public void onNotStartingWithServletAlias() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XshouldStartWithY", WsPropertiesNewWsdlWizardPage.this.m_urlPattern.getLabelText(), WsPropertiesNewWsdlWizardPage.this.m_jaxWsServletAlias)));
                }

                @Override
                public void onIllegalCharacters() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidUrlX", urlPattern)));
                }

                @Override
                public void onEmpty() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", WsPropertiesNewWsdlWizardPage.this.m_urlPattern.getLabelText())));
                }
            });
            if (this.m_illegalUrlPatterns.contains(urlPattern)) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XWithYDoesAlreadyExist", this.m_urlPattern.getLabelText(), urlPattern)));
            }
        }
        this.validateTargetNamespace(multiStatus);
        this.validateJavaField(multiStatus, this.m_serviceNameField.getLabelText(), this.getServiceName());
        this.validateJavaField(multiStatus, this.m_portNameField.getLabelText(), this.getPortName());
        this.validateJavaField(multiStatus, this.m_bindingNameField.getLabelText(), this.getBinding());
        this.validateJavaField(multiStatus, this.m_portTypeNameField.getLabelText(), this.getPortTypeName());
        if (StringUtility.isNullOrEmpty((String)this.getServiceOperationName())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_serviceOperationNameField.getLabelText())));
        } else {
            validationStatus = JavaConventionsUtil.validateMethodName((String)this.getServiceOperationName(), (IJavaElement)this.m_bundle.getJavaProject());
            multiStatus.add(validationStatus);
        }
    }

    public void setWsdlName(String wsdlName) {
        try {
            this.setStateChanging(true);
            this.setWsdlNameInternal(wsdlName);
            if (this.isControlCreated()) {
                this.m_wsdlNameField.setText(wsdlName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setWsdlNameInternal(String wsdlName) {
        this.m_propertySupport.setPropertyString(PROP_WSDL_NAME, wsdlName);
    }

    public String getWsdlName() {
        return this.m_propertySupport.getPropertyString(PROP_WSDL_NAME);
    }

    public void setDeriveOtherNames(boolean deriveOtherNames) {
        try {
            this.setStateChanging(true);
            this.setDeriveOtherNamesInternal(deriveOtherNames);
            if (this.isControlCreated()) {
                this.m_deriveOtherNameButton.setSelection(deriveOtherNames);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setDeriveOtherNamesInternal(boolean deriveOtherNames) {
        this.m_propertySupport.setPropertyBool(PROP_DERIVE_OTHER_NAME, deriveOtherNames);
    }

    public boolean isDeriveOtherNames() {
        return this.m_propertySupport.getPropertyBool(PROP_DERIVE_OTHER_NAME);
    }

    public void setAlias(String alias) {
        try {
            this.setStateChanging(true);
            this.setAliasInternal(alias);
            if (this.isControlCreated()) {
                this.m_alias.setText(alias);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAliasInternal(String alias) {
        this.m_propertySupport.setPropertyString(PROP_ALIAS, alias);
    }

    public String getAlias() {
        return this.m_propertySupport.getPropertyString(PROP_ALIAS);
    }

    public void setUrlPattern(String urlPattern) {
        try {
            this.setStateChanging(true);
            this.setUrlPatternInternal(urlPattern);
            if (this.isControlCreated()) {
                this.m_urlPattern.setText(urlPattern);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUrlPatternInternal(String urlPattern) {
        this.m_propertySupport.setPropertyString(PROP_URL_PATTERN, urlPattern);
    }

    public String getUrlPattern() {
        return this.m_propertySupport.getPropertyString(PROP_URL_PATTERN);
    }

    public void setJaxWsServletAlias(String jaxWsServletAlias) {
        this.m_jaxWsServletAlias = jaxWsServletAlias;
        if (this.isControlCreated()) {
            this.m_urlPattern.setReadOnlyPrefix(new Path(PathNormalizer.toServletAlias(this.m_jaxWsServletAlias)).addTrailingSeparator().toString());
        }
    }

    public void setTargetNamespace(String targetNamespace) {
        try {
            this.setStateChanging(true);
            this.setTargetNamespaceInternal(targetNamespace);
            if (this.isControlCreated()) {
                this.m_targetNamespaceField.setText(targetNamespace);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTargetNamespaceInternal(String targetNamespace) {
        this.m_propertySupport.setPropertyString(PROP_TARGET_NAMESPACE, targetNamespace);
    }

    public String getTargetNamespace() {
        return this.m_propertySupport.getPropertyString(PROP_TARGET_NAMESPACE);
    }

    public void setBindingName(String bindingName) {
        try {
            this.setStateChanging(true);
            this.setBindingNameInternal(bindingName);
            if (this.isControlCreated()) {
                this.m_bindingNameField.setText(bindingName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setBindingNameInternal(String bindingName) {
        this.m_propertySupport.setPropertyString(PROP_BINDING_NAME, bindingName);
    }

    public String getBinding() {
        return this.m_propertySupport.getPropertyString(PROP_BINDING_NAME);
    }

    public void setServiceName(String serviceName) {
        try {
            this.setStateChanging(true);
            this.setServiceNameInternal(serviceName);
            if (this.isControlCreated()) {
                this.m_serviceNameField.setText(serviceName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setServiceNameInternal(String serviceName) {
        this.m_propertySupport.setPropertyString(PROP_SERVICE_NAME, serviceName);
    }

    public String getServiceName() {
        return this.m_propertySupport.getPropertyString(PROP_SERVICE_NAME);
    }

    public void setPortTypeName(String portTypeName) {
        try {
            this.setStateChanging(true);
            this.setPortTypeNameInternal(portTypeName);
            if (this.isControlCreated()) {
                this.m_portTypeNameField.setText(portTypeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPortTypeNameInternal(String portTypeName) {
        this.m_propertySupport.setPropertyString(PROP_PORT_TYPE_NAME, portTypeName);
    }

    public String getPortTypeName() {
        return this.m_propertySupport.getPropertyString(PROP_PORT_TYPE_NAME);
    }

    public void setPortName(String portName) {
        try {
            this.setStateChanging(true);
            this.setPortNameInternal(portName);
            if (this.isControlCreated()) {
                this.m_portNameField.setText(portName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPortNameInternal(String portName) {
        this.m_propertySupport.setPropertyString(PROP_PORT_NAME, portName);
    }

    public String getPortName() {
        return this.m_propertySupport.getPropertyString(PROP_PORT_NAME);
    }

    public void setServiceOperationName(String serviceOperationName) {
        try {
            this.setStateChanging(true);
            this.setServiceOperationNameInternal(serviceOperationName);
            if (this.isControlCreated()) {
                this.m_serviceOperationNameField.setText(serviceOperationName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setServiceOperationNameInternal(String serviceOperationName) {
        this.m_propertySupport.setPropertyString(PROP_SERVICE_OPERATION_NAME, serviceOperationName);
    }

    public String getServiceOperationName() {
        return this.m_propertySupport.getPropertyString(PROP_SERVICE_OPERATION_NAME);
    }

    public void setWsdlStyle(WsdlStyleEnum wsdlStyleEnum) {
        try {
            this.setStateChanging(true);
            this.setWsdlStyleInternal(wsdlStyleEnum);
            if (this.isControlCreated()) {
                for (Button radioButton : this.m_wsdlStyleRadioButtons) {
                    radioButton.setSelection(wsdlStyleEnum == (WsdlStyleEnum)((Object)radioButton.getData("ID")));
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setWsdlStyleInternal(WsdlStyleEnum wsdlStyleEnum) {
        this.m_propertySupport.setProperty(PROP_WSDL_STYLE, (Object)wsdlStyleEnum);
    }

    public WsdlStyleEnum getWsdlStyle() {
        return (WsdlStyleEnum)((Object)this.m_propertySupport.getProperty(PROP_WSDL_STYLE));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    private void validateTargetNamespace(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((String)this.m_targetNamespaceField.getText())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_targetNamespaceField.getLabelText())));
        } else {
            try {
                new URL(this.m_targetNamespaceField.getText());
            }
            catch (MalformedURLException malformedURLException) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("TargetNamespaceMustBeValudUrl")));
            }
            if (!this.m_targetNamespaceField.getText().endsWith("/")) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "Target Namespace must end with a slash"));
            }
        }
    }

    private void validateJavaField(MultiStatus multiStatus, String label, String text) {
        if (StringUtility.isNullOrEmpty((String)text)) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", label)));
            return;
        }
        IStatus validationStatus = this.m_bundle.getProject().getWorkspace().validateName(text, 1);
        multiStatus.add(validationStatus);
        validationStatus = JavaConventionsUtil.validateJavaTypeName((String)text, (IJavaElement)this.m_bundle.getJavaProject());
        multiStatus.add(validationStatus);
        if (Character.isLowerCase(text.charAt(0))) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UpperCaseHint")));
        }
    }

    private void deriveOtherNames() {
        if (!this.isDeriveOtherNames()) {
            return;
        }
        String serviceName = this.getWsdlName().substring(0, this.getWsdlName().length() - ".wsdl".length());
        this.setTargetNamespace(JaxWsSdkUtility.getRecommendedTargetNamespace(this.m_bundle, serviceName));
        this.setServiceName(serviceName);
        this.setPortName(String.valueOf(serviceName) + "Port");
        this.setBindingName(String.valueOf(serviceName) + "PortSoapBinding");
        this.setPortTypeName(String.valueOf(serviceName) + "PortType");
        this.setAlias(serviceName);
        this.setUrlPattern(serviceName);
        this.setServiceOperationName(JaxWsSdkUtility.toStartWithLowerCase(serviceName.substring(0, serviceName.length() - "WebService".length())));
    }

    private void loadIllegalValues() {
        HashSet<String> illegalAliases = new HashSet<String>();
        HashSet<String> illegalUrlPatterns = new HashSet<String>();
        if (this.m_sunJaxWsXml != null) {
            for (ScoutXmlDocument.ScoutXmlElement xmlSunJaxWs : this.m_sunJaxWsXml.getRoot().getChildren(StringUtility.join((String)":", (Object[])new Object[]{this.m_sunJaxWsXml.getRoot().getNamePrefix(), "endpoint"}))) {
                SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(xmlSunJaxWs);
                illegalAliases.add(sunJaxWsBean.getAlias());
                illegalUrlPatterns.add(sunJaxWsBean.getUrlPattern());
            }
        }
        this.m_illegalAliasNames = illegalAliases;
        this.m_illegalUrlPatterns = illegalUrlPatterns;
    }

    public boolean isShowOnlyWsdlProperties() {
        return this.m_showOnlyWsdlProperties;
    }

    public void setShowOnlyWsdlProperties(boolean showOnlyWsdlProperties) {
        this.m_showOnlyWsdlProperties = showOnlyWsdlProperties;
    }
}

