/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.delete.DeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.ScoutSeverityManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;

public class SessionFactoryNodePage
extends AbstractPage {
    private IType m_type;
    private IScoutBundle m_bundle;

    public SessionFactoryNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setName(type.getElementName());
        this.m_type = type;
        if (type.isBinary()) {
            this.setImageDescriptor(JaxWsSdk.getImageDescriptor("session_binary.png"));
        } else {
            this.setImageDescriptor(JaxWsSdk.getImageDescriptor("session.png"));
        }
        this.m_bundle = this.getScoutResource();
    }

    public String getPageId() {
        return IJaxWsPageConstants.SESSION_FACTORY_NODE_PAGE;
    }

    public int getQuality() {
        int quality = 0;
        if (this.getType().exists()) {
            quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType());
        }
        return quality;
    }

    public boolean handleDoubleClickedDelegate() {
        if (this.getType() != null) {
            try {
                JavaUI.openInEditor((IJavaElement)this.getType());
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("could not open type in editor", e);
            }
            return true;
        }
        return false;
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        if (!this.m_type.isBinary()) {
            return new Class[]{DeleteAction.class, TypeRenameAction.class, ShowJavaReferencesAction.class};
        }
        return new Class[]{ShowJavaReferencesAction.class};
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof TypeRenameAction) {
            TypeRenameAction action = (TypeRenameAction)menu;
            action.setOldName(this.getType().getElementName());
            action.setType(this.getType());
        } else if (menu instanceof ShowJavaReferencesAction) {
            ((ShowJavaReferencesAction)menu).setElement((IJavaElement)this.getType());
        } else if (menu instanceof DeleteAction) {
            ((DeleteAction)menu).addType(this.getType());
            ((DeleteAction)menu).setName(this.getType().getElementName());
        }
    }

    public boolean isFolder() {
        return false;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public IType getType() {
        return this.m_type;
    }
}

