/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FilePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.WsdlLocationWizard;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.Composite;

public class WsdlFilePresenter
extends FilePresenter {
    private BuildJaxWsBean m_buildJaxWsBean;
    private SunJaxWsBean m_sunJaxWsBean;

    public WsdlFilePresenter(IScoutBundle bundle, Composite parent, PropertyViewFormToolkit toolkit) {
        super(parent, toolkit);
        this.setBundle(bundle);
        this.setLabel(Texts.get("WsdlFile"));
        this.setUseLinkAsLabel(true);
        this.setFileExtension("wsdl");
        if (this.m_sunJaxWsBean != null) {
            this.setFileDirectory(JaxWsSdkUtility.getFolder(bundle, JaxWsConstants.PATH_WSDL_PROVIDER, false));
        } else {
            this.setFileDirectory(JaxWsSdkUtility.getFolder(bundle, JaxWsConstants.PATH_WSDL_CONSUMER, false));
        }
    }

    @Override
    protected IFile execBrowseAction() {
        WsdlLocationWizard wizard = new WsdlLocationWizard(this.m_bundle, this.m_buildJaxWsBean, this.m_sunJaxWsBean);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setPageSize(650, 350);
        wizardDialog.open();
        return null;
    }

    @Override
    protected String getConfiguredBrowseButtonLabel() {
        return Texts.get("Change");
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
    }
}

