/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util.listener;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;

public abstract class AbstractTypeChangedListener
implements IResourceChangeListener {
    private IType m_type;

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.shouldAnalayseForChange(event)) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        if (this.m_type == null) {
            return;
        }
        if (!this.m_type.exists()) {
            this.typeChanged();
            return;
        }
        try {
            IResourceDelta rootDelta = event.getDelta();
            rootDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource;
                    if (AbstractTypeChangedListener.this.m_type == null) {
                        return false;
                    }
                    if ((delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) && (resource = delta.getResource()).getType() == 1 && resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase("java") && resource.getName().endsWith(String.valueOf(AbstractTypeChangedListener.this.m_type.getElementName()) + ".java") && resource.getProject() == AbstractTypeChangedListener.this.m_type.getJavaProject().getProject()) {
                        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
                        if (cu == null) {
                            JaxWsSdk.logError("Compilation unit of file '" + resource.getName() + "' could not be determined.");
                            return true;
                        }
                        IType[] iTypeArray = cu.getTypes();
                        int n = iTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType typeChanged = iTypeArray[n2];
                            if (TypeUtility.exists((IJavaElement)typeChanged)) {
                                typeChanged = TypeUtility.getToplevelType((IType)typeChanged);
                            }
                            if (TypeUtility.exists((IJavaElement)typeChanged) && CompareUtility.equals((Object)typeChanged, (Object)AbstractTypeChangedListener.this.m_type)) {
                                AbstractTypeChangedListener.this.typeChanged();
                                return false;
                            }
                            ++n2;
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            JaxWsSdk.logError("Unexpected error occured while intercepting resource changed event.", e);
        }
    }

    protected boolean shouldAnalayseForChange(IResourceChangeEvent event) {
        return true;
    }

    protected abstract void typeChanged();

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }
}

