/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.xmleditor.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.xmleditor.Messages;
import org.eclipse.soa.sca.core.common.utils.DomUtils;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaFileHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document = textViewer.getDocument();
        Node node = this.getNodeByOffset(document, region.getOffset());
        if (node != null) {
            Element elt = null;
            if (node.getNodeType() == 1) {
                elt = (Element)node;
            } else if (node.getNodeType() == 2) {
                elt = ((Attr)node).getOwnerElement();
            }
            if (elt == null) {
                return new IHyperlink[0];
            }
            String name = DomUtils.getNodeName(elt).toLowerCase();
            String className = null;
            if (name.equals("interface.java")) {
                className = elt.getAttribute("interface");
            }
            if (name.equals("implementation.java")) {
                className = elt.getAttribute("class");
            }
            if (className == null) {
                return new IHyperlink[0];
            }
            IRegion nodeRegion = region;
            try {
                IRegion lineRegion = document.getLineInformationOfOffset(region.getOffset());
                String lineText = document.get(lineRegion.getOffset(), lineRegion.getLength());
                if (!lineText.contains(className)) {
                    return new IHyperlink[0];
                }
                int length = className.length();
                int start = lineRegion.getOffset() + lineText.indexOf(className);
                nodeRegion = new Region(start, length);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            IFile file = ResourceUtils.getIFileFromEditor();
            if (file == null) {
                return new IHyperlink[0];
            }
            IProject project = file.getProject();
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return new IHyperlink[0];
                }
            }
            catch (CoreException coreException) {
                return new IHyperlink[0];
            }
            IJavaProject jp = JavaCore.create((IProject)project);
            try {
                final IType type = jp.findType(className);
                final String cl = className;
                final IRegion nr = nodeRegion;
                IHyperlink pomHyperlink = new IHyperlink(){

                    public IRegion getHyperlinkRegion() {
                        return nr;
                    }

                    public String getHyperlinkText() {
                        return cl;
                    }

                    public String getTypeLabel() {
                        return "Java SCA";
                    }

                    public void open() {
                        try {
                            if (type != null) {
                                JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                            } else {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog.openWarning((Shell)new Shell(), (String)Messages.JavaFileHyperlinkDetector_0, (String)Messages.JavaFileHyperlinkDetector_1);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            ScaCoreCommonPlugin.log(e, 4);
                        }
                    }
                };
                return new IHyperlink[]{pomHyperlink};
            }
            catch (JavaModelException e1) {
                ScaCoreCommonPlugin.log((Exception)((Object)e1), 4);
            }
        }
        return new IHyperlink[0];
    }

    protected final Node getNodeByOffset(IDocument document, int offset) {
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            IndexedRegion indexedRegion = model.getIndexedRegion(offset);
            if (indexedRegion == null) {
                indexedRegion = model.getIndexedRegion(offset - 1);
            }
            if (indexedRegion instanceof Node) {
                return (Node)indexedRegion;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

