/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_1.common.composite2java;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.soa.sca.core.common.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JInterface {
    protected String name;
    protected boolean isRemotable = true;
    protected Map<String, JInterface> interfaces = new HashMap<String, JInterface>();

    public boolean equals(Object obj) {
        return obj != null && obj instanceof JInterface && this.name != null && this.name.equals(((JInterface)obj).name);
    }

    public int hashCode() {
        if (this.getName() == null) {
            return 173;
        }
        return this.getName().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRemotable() {
        return this.isRemotable;
    }

    public void setRemotable(boolean isRemotable) {
        this.isRemotable = isRemotable;
    }

    public Map<String, JInterface> getInterfaces() {
        return this.interfaces;
    }

    public boolean hasInterface(Object key) {
        return this.interfaces.containsKey(key);
    }

    public Set<Map.Entry<String, JInterface>> superInterfaceEntrySet() {
        return this.interfaces.entrySet();
    }

    public JInterface getInterface(Object key) {
        return this.interfaces.get(key);
    }

    public JInterface putInterface(String key, JInterface value) {
        return this.interfaces.put(key, value);
    }

    public JInterface removeInterface(Object key) {
        return this.interfaces.remove(key);
    }

    public String getJavaCode(IFile compositeFile) {
        String[] qnElements = JDTUtils.getQualifiedNameElements((String)this.name);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGenerationComment(compositeFile));
        sb.append(this.getPackageDeclaration(qnElements));
        for (String imp : this.getImports(qnElements)) {
            sb.append("import " + imp + ";\n");
        }
        sb.append("\n");
        sb.append(this.getDeclaration(qnElements));
        sb.append(this.getBody());
        return sb.toString();
    }

    protected String getBody() {
        return " {\n\n\t// TODO: add the service operations.\n}";
    }

    protected String getDeclaration(String[] qnElements) {
        StringBuilder result = new StringBuilder();
        if (this.isRemotable) {
            result.append("@Remotable\n");
        }
        result.append("public interface " + qnElements[1]);
        if (this.interfaces.size() > 0) {
            result.append(" extends ");
        }
        Iterator<String> it = this.interfaces.keySet().iterator();
        while (it.hasNext()) {
            result.append(JDTUtils.getQualifiedNameElements((String)it.next())[1]);
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected TreeSet<String> getImports(String[] qnElements) {
        TreeSet<String> imports = new TreeSet<String>();
        if (this.isRemotable()) {
            imports.add("org.osoa.sca.annotations.Remotable");
        }
        for (String ei : this.interfaces.keySet()) {
            String[] qne = JDTUtils.getQualifiedNameElements((String)ei);
            if (qne[0].equals(qnElements[0])) continue;
            imports.add(ei);
        }
        return imports;
    }

    protected String getGenerationComment(IFile compositeFile) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy 'at' HH:mm:ss");
        String date = df.format(new GregorianCalendar().getTime());
        String compositeText = compositeFile != null ? compositeFile.getName() : "a composite file";
        return "/*\n * Generated from " + compositeText + " on " + date + ".\n */\n\n";
    }

    protected String getPackageDeclaration(String[] qnElements) {
        return "package " + qnElements[0] + ";\n\n";
    }
}

