/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.launch;

import org.eclipse.cdt.launch.ui.CMainTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.cdt.ui.launch.PeerListControl;
import org.eclipse.tcf.internal.cdt.ui.launch.RemoteFileSelectionDialog;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.PlatformUI;

public class RemoteCMainTab
extends CMainTab
implements IShellProvider {
    private static final String REMOTE_PATH_DEFAULT = "";
    private static final boolean SKIP_DOWNLOAD_TO_REMOTE_DEFAULT = false;
    private PeerListControl fPeerList;
    private Text fRemoteProgText;
    private Button fRemoteBrowseButton;
    private Button fSkipDownloadButton;
    private boolean fIsInitializing = false;
    private PeerListControl.PeerInfo fSelectedPeer;
    private boolean fPeerHasFileSystemService;
    private boolean fPeerHasProcessesService;

    public RemoteCMainTab() {
        super(false);
    }

    public Shell getShell() {
        return super.getShell();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        this.setControl((Control)comp);
        comp.setLayout((Layout)topLayout);
        this.createPeerListGroup(comp);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createBuildConfigCombo(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        this.createTargetExePathGroup(comp);
        this.createDownloadOption(comp);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCMainTab.this.setLocalPathForRemotePath();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.tcf.cdt.ui.remoteApplicationLaunchGroup");
    }

    private void createPeerListGroup(Composite comp) {
        new Label(comp, 0).setText("Targets:");
        this.fPeerList = new PeerListControl(comp);
        this.fPeerList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemoteCMainTab.this.handlePeerSelectionChanged();
                RemoteCMainTab.this.useDefaultsFromConnection();
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean valid = super.isValid(config);
        if (valid) {
            String name;
            if (this.fSelectedPeer == null) {
                this.setErrorMessage("No target selected.");
                valid = false;
            } else if (!this.fPeerHasProcessesService) {
                this.setErrorMessage("Selected target does not support 'Processes' service");
                valid = false;
            }
            if (valid && (name = this.fRemoteProgText.getText().trim()).length() == 0) {
                this.setErrorMessage("Remote executable path is not specified.");
                valid = false;
            }
        }
        return valid;
    }

    protected void createTargetExePathGroup(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        Label remoteProgLabel = new Label(mainComp, 0);
        remoteProgLabel.setText("Remote Absolute File Path for C/C++ Application:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        remoteProgLabel.setLayoutData((Object)gd);
        this.fRemoteProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fRemoteProgText.setLayoutData((Object)gd);
        this.fRemoteProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoteBrowseButton = this.createPushButton(mainComp, "Browse...", null);
        this.fRemoteBrowseButton.setEnabled(this.fPeerHasFileSystemService);
        this.fRemoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCMainTab.this.handleRemoteBrowseSelected();
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createDownloadOption(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.fSkipDownloadButton = this.createCheckButton(mainComp, "Skip download to target path.");
        this.fSkipDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSkipDownloadButton.setEnabled(this.fPeerHasFileSystemService);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", false);
        config.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String peerId = this.getSelectedPeerId();
        if (peerId != null) {
            config.setAttribute("org.eclipse.tcf.debug.PeerID", peerId);
        }
        config.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", false);
        config.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", false);
        config.setAttribute("org.eclipse.tcf.debug.ProgramFile", this.fRemoteProgText.getText());
        config.setAttribute("org.eclipse.tcf.debug.CopyToRemote", !this.fSkipDownloadButton.getSelection());
        super.performApply(config);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fIsInitializing = true;
        super.initializeFrom(config);
        this.updatePeerFromConfig(config);
        this.updateTargetProgFromConfig(config);
        this.updateSkipDownloadFromConfig(config);
        this.fIsInitializing = false;
    }

    protected void updatePeerFromConfig(ILaunchConfiguration config) {
        try {
            String peerId = config.getAttribute("org.eclipse.tcf.debug.PeerID", null);
            if (peerId != null) {
                PeerListControl.PeerInfo info = this.fPeerList.findPeerInfo(peerId);
                if (info != null) {
                    this.fPeerList.setSelection((ISelection)new StructuredSelection((Object)info));
                    this.handlePeerSelectionChanged();
                } else {
                    this.fPeerList.setInitialSelectedPeerId(peerId);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected void handleRemoteBrowseSelected() {
        String file;
        RemoteFileSelectionDialog dialog = new RemoteFileSelectionDialog(this, 8192);
        dialog.setSelection(this.fRemoteProgText.getText().trim());
        dialog.setPeer(this.fSelectedPeer.peer);
        if (dialog.open() == 0 && (file = dialog.getSelection()) != null) {
            this.fRemoteProgText.setText(file);
        }
    }

    protected void updateTargetProgFromConfig(ILaunchConfiguration config) {
        String targetPath = REMOTE_PATH_DEFAULT;
        try {
            targetPath = config.getAttribute("org.eclipse.tcf.debug.ProgramFile", REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {}
        this.fRemoteProgText.setText(targetPath);
    }

    protected void updateSkipDownloadFromConfig(ILaunchConfiguration config) {
        boolean doDownload = true;
        try {
            doDownload = config.getAttribute("org.eclipse.tcf.debug.CopyToRemote", doDownload);
        }
        catch (CoreException coreException) {}
        this.fSkipDownloadButton.setSelection(!doDownload);
    }

    private void setLocalPathForRemotePath() {
        String programName = this.fProgText.getText().trim();
        boolean bUpdateRemote = false;
        String remoteName = this.fRemoteProgText.getText().trim();
        String remoteWsRoot = this.getRemoteWSRoot();
        if (remoteName.length() == 0) {
            bUpdateRemote = true;
        } else if (remoteWsRoot.length() != 0) {
            bUpdateRemote = remoteName.equals(remoteWsRoot);
        }
        if (programName.length() != 0 && bUpdateRemote && this.getCProject() != null) {
            IProject project = this.getCProject().getProject();
            Path exePath = new Path(programName);
            if (!exePath.isAbsolute()) {
                exePath = project.getFile(programName).getLocation();
                IPath wsRoot = project.getWorkspace().getRoot().getLocation();
                exePath = this.makeRelativeToWSRootLocation((IPath)exePath, remoteWsRoot, wsRoot);
            }
            String path = exePath.toString();
            this.fRemoteProgText.setText(path);
        }
    }

    private void useDefaultsFromConnection() {
        if (this.fIsInitializing) {
            return;
        }
        if (this.fRemoteProgText != null && !this.fRemoteProgText.isDisposed()) {
            String remoteName = this.fRemoteProgText.getText().trim();
            String remoteWsRoot = this.getRemoteWSRoot();
            if (remoteName.length() == 0) {
                this.fRemoteProgText.setText(remoteWsRoot);
            } else {
                IPath wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                IPath remotePath = this.makeRelativeToWSRootLocation((IPath)new Path(remoteName), remoteWsRoot, wsRoot);
                this.fRemoteProgText.setText(remotePath.toString());
            }
        }
        boolean hasFileSystemService = this.hasFileSystemService();
        if (this.fSkipDownloadButton != null && !this.fSkipDownloadButton.isDisposed()) {
            this.fSkipDownloadButton.setEnabled(hasFileSystemService);
        }
        if (this.fRemoteBrowseButton != null && !this.fRemoteBrowseButton.isDisposed()) {
            this.fRemoteBrowseButton.setEnabled(hasFileSystemService);
        }
    }

    private boolean hasFileSystemService() {
        return this.fPeerHasFileSystemService;
    }

    private void handlePeerSelectionChanged() {
        ISelection selection = this.fPeerList.getSelection();
        final PeerListControl.PeerInfo info = selection instanceof IStructuredSelection ? (PeerListControl.PeerInfo)((IStructuredSelection)selection).getFirstElement() : null;
        this.fSelectedPeer = info;
        this.fPeerHasFileSystemService = false;
        this.fPeerHasProcessesService = false;
        if (info != null) {
            Boolean[] available = (Boolean[])new TCFTask<Boolean[]>(){

                public void run() {
                    final IChannel channel = info.peer.openChannel();
                    channel.addChannelListener(new IChannel.IChannelListener(){
                        boolean opened;

                        public void congestionLevel(int level) {
                        }

                        public void onChannelClosed(Throwable error) {
                            if (!this.opened) {
                                this.done(new Boolean[]{false, false});
                            }
                        }

                        public void onChannelOpened() {
                            this.opened = true;
                            Boolean hasFileSystemService = channel.getRemoteService(IFileSystem.class) != null;
                            Boolean hasProcessesService = channel.getRemoteService(IProcesses.class) != null;
                            channel.close();
                            this.done(new Boolean[]{hasFileSystemService, hasProcessesService});
                        }
                    });
                }
            }.getE();
            this.fPeerHasFileSystemService = available[0];
            this.fPeerHasProcessesService = available[1];
        }
    }

    private PeerListControl.PeerInfo getSelectedPeer() {
        return this.fSelectedPeer;
    }

    private String getSelectedPeerId() {
        PeerListControl.PeerInfo info = this.getSelectedPeer();
        if (info != null) {
            return info.id;
        }
        return null;
    }

    private IPath makeRelativeToWSRootLocation(IPath exePath, String remoteWsRoot, IPath wsRoot) {
        if (remoteWsRoot.length() != 0 && wsRoot.isPrefixOf(exePath)) {
            return new Path(remoteWsRoot).append(exePath.removeFirstSegments(wsRoot.segmentCount()).setDevice(null));
        }
        return exePath;
    }

    private String getRemoteWSRoot() {
        return REMOTE_PATH_DEFAULT;
    }
}

