/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.core;

import java.io.IOException;
import java.util.Map;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.internal.core.RemotePeer;
import org.eclipse.tcf.internal.services.local.LocatorService;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPeer
extends TransientPeer {
    private long last_heart_beat_time;

    public AbstractPeer(Map<String, String> attrs) {
        super(attrs);
        assert (Protocol.isDispatchThread());
        String id = this.getID();
        assert (id != null);
        Map<String, IPeer> peers = LocatorService.getLocator().getPeers();
        if (peers.get(id) instanceof RemotePeer) {
            ((RemotePeer)peers.get(id)).dispose();
        }
        assert (peers.get(id) == null);
        peers.put(id, this);
        this.sendPeerAddedEvent();
    }

    public void dispose() {
        assert (Protocol.isDispatchThread());
        String id = this.getID();
        assert (id != null);
        Map<String, IPeer> peers = LocatorService.getLocator().getPeers();
        assert (peers.get(id) == this);
        peers.remove(id);
        this.sendPeerRemovedEvent();
    }

    void onChannelTerminated() {
        this.last_heart_beat_time = 0L;
    }

    public void updateAttributes(Map<String, String> attrs) {
        long time = System.currentTimeMillis();
        if (!attrs.equals(this.ro_attrs)) {
            assert (attrs.get("ID").equals(this.rw_attrs.get("ID")));
            this.rw_attrs.clear();
            this.rw_attrs.putAll(attrs);
            ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
            int n = locatorListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocator.LocatorListener l = locatorListenerArray[n2];
                try {
                    l.peerChanged(this);
                }
                catch (Throwable x) {
                    Protocol.log("Unhandled exception in Locator listener", x);
                }
                ++n2;
            }
            try {
                Object[] args = new Object[]{this.rw_attrs};
                Protocol.sendEvent("Locator", "peerChanged", JSON.toJSONSequence(args));
            }
            catch (IOException x) {
                Protocol.log("Locator: failed to send 'peerChanged' event", x);
            }
            this.last_heart_beat_time = time;
        } else if (this.last_heart_beat_time + 15000L < time) {
            ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
            int n = locatorListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                ILocator.LocatorListener l = locatorListenerArray[n3];
                try {
                    l.peerHeartBeat(attrs.get("ID"));
                }
                catch (Throwable x) {
                    Protocol.log("Unhandled exception in Locator listener", x);
                }
                ++n3;
            }
            try {
                Object[] args = new Object[]{this.rw_attrs.get("ID")};
                Protocol.sendEvent("Locator", "peerHeartBeat", JSON.toJSONSequence(args));
            }
            catch (IOException x) {
                Protocol.log("Locator: failed to send 'peerHeartBeat' event", x);
            }
            this.last_heart_beat_time = time;
        }
    }

    private void sendPeerAddedEvent() {
        ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
        int n = locatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocator.LocatorListener l = locatorListenerArray[n2];
            try {
                l.peerAdded(this);
            }
            catch (Throwable x) {
                Protocol.log("Unhandled exception in Locator listener", x);
            }
            ++n2;
        }
        try {
            Object[] args = new Object[]{this.rw_attrs};
            Protocol.sendEvent("Locator", "peerAdded", JSON.toJSONSequence(args));
        }
        catch (IOException x) {
            Protocol.log("Locator: failed to send 'peerAdded' event", x);
        }
        this.last_heart_beat_time = System.currentTimeMillis();
    }

    private void sendPeerRemovedEvent() {
        ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
        int n = locatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocator.LocatorListener l = locatorListenerArray[n2];
            try {
                l.peerRemoved((String)this.rw_attrs.get("ID"));
            }
            catch (Throwable x) {
                Protocol.log("Unhandled exception in Locator listener", x);
            }
            ++n2;
        }
        try {
            Object[] args = new Object[]{this.rw_attrs.get("ID")};
            Protocol.sendEvent("Locator", "peerRemoved", JSON.toJSONSequence(args));
        }
        catch (IOException x) {
            Protocol.log("Locator: failed to send 'peerRemoved' event", x);
        }
    }
}

