/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.util.TCFPathMapRule;

public class PathMapProxy
implements IPathMap {
    private final IChannel channel;
    private final Map<IPathMap.PathMapListener, IChannel.IEventListener> listeners = new HashMap<IPathMap.PathMapListener, IChannel.IEventListener>();

    static {
        JSON.addObjectWriter(IPathMap.PathMapRule.class, new JSON.ObjectWriter<IPathMap.PathMapRule>(){

            @Override
            public void write(IPathMap.PathMapRule r) throws IOException {
                JSON.writeObject(r.getProperties());
            }
        });
    }

    public PathMapProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "PathMap";
    }

    public IToken get(final IPathMap.DoneGet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"get", null){

            public void done(Exception error, Object[] args) {
                IPathMap.PathMapRule[] map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = PathMapProxy.this.toPathMap(args[1]);
                }
                done.doneGet(this.token, error, map);
            }
        }.token;
    }

    public IToken set(IPathMap.PathMapRule[] map, final IPathMap.DoneSet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"set", (Object[])new Object[]{map}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneSet(this.token, error);
            }
        }.token;
    }

    private IPathMap.PathMapRule[] toPathMap(Object o) {
        if (o == null) {
            return null;
        }
        int i = 0;
        Collection c = (Collection)o;
        IPathMap.PathMapRule[] map = new IPathMap.PathMapRule[c.size()];
        for (Object x : c) {
            map[i++] = this.toPathMapRule(x);
        }
        return map;
    }

    private IPathMap.PathMapRule toPathMapRule(Object o) {
        if (o == null) {
            return null;
        }
        return new TCFPathMapRule((Map)o);
    }

    public void addListener(final IPathMap.PathMapListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            public void event(String name, byte[] data) {
                try {
                    Object[] args = JSON.parseSequence(data);
                    if (name.equals("changed")) {
                        if (!$assertionsDisabled && args.length != 0) {
                            throw new AssertionError();
                        }
                    } else {
                        throw new IOException("Path Map service: unknown event: " + name);
                    }
                    listener.changed();
                }
                catch (Throwable x) {
                    PathMapProxy.this.channel.terminate(x);
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    public void removeListener(IPathMap.PathMapListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }
}

