/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapWidget;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;

class MemoryMapDialog
extends Dialog {
    private final TCFNode node;
    private final ILaunchConfiguration cfg;
    private MemoryMapWidget widget;
    private Button ok_button;

    MemoryMapDialog(Shell parent, TCFNode node) {
        super(parent);
        this.node = node;
        this.cfg = node.getModel().getLaunch().getLaunchConfiguration();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Symbol Files");
        shell.setImage(ImageCache.getImage("icons/memory-map.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.ok_button = this.createButton(parent, 0, "&OK", true);
        this.ok_button.setEnabled(this.widget != null && this.widget.getMemoryMapID() != null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.widget = new MemoryMapWidget(composite, this.node);
        this.widget.loadData(this.cfg);
        if (this.ok_button != null) {
            this.ok_button.setEnabled(this.widget.getMemoryMapID() != null);
        }
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    protected void okPressed() {
        try {
            ILaunchConfigurationWorkingCopy copy = this.cfg.getWorkingCopy();
            if (this.widget.saveData(copy)) {
                copy.doSave();
            }
            super.okPressed();
        }
        catch (Throwable x) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText("Cannot update memory map");
            mb.setMessage(TCFModel.getErrorMessage(x, true));
            mb.open();
        }
    }
}

