/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFRunnable;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;

public class TerminateCommand
implements ITerminateHandler {
    public TerminateCommand(TCFModel model) {
    }

    public void canExecute(final IEnabledStateRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                Object[] elements = monitor.getElements();
                boolean res = false;
                int i = 0;
                while (i < elements.length) {
                    TCFNode node = null;
                    if (elements[i] instanceof TCFNode) {
                        node = (TCFNode)elements[i];
                    }
                    block1: while (node != null && !node.isDisposed()) {
                        if (node instanceof TCFNodeExecContext) {
                            TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)cache.getData();
                            if (ctx != null && ctx.canTerminate()) {
                                res = true;
                                break;
                            }
                            TCFChildren children_cache = ((TCFNodeExecContext)node).getChildren();
                            if (!children_cache.validate(this)) {
                                return;
                            }
                            TCFNode[] tCFNodeArray = children_cache.toArray();
                            int n = tCFNodeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TCFNode child = tCFNodeArray[n2];
                                cache = ((TCFNodeExecContext)child).getRunContext();
                                if (!cache.validate((Runnable)this)) {
                                    return;
                                }
                                ctx = (IRunControl.RunControlContext)cache.getData();
                                if (ctx != null && ctx.canTerminate()) {
                                    res = true;
                                    break block1;
                                }
                                ++n2;
                            }
                            break;
                        }
                        node = node.getParent();
                    }
                    ++i;
                }
                monitor.setEnabled(res);
                monitor.setStatus(Status.OK_STATUS);
                this.done();
            }
        };
    }

    public boolean execute(final IDebugCommandRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                Object[] elements = monitor.getElements();
                HashSet<IRunControl.RunControlContext> set = new HashSet<IRunControl.RunControlContext>();
                int i = 0;
                while (i < elements.length) {
                    TCFNode node = null;
                    if (elements[i] instanceof TCFNode) {
                        node = (TCFNode)elements[i];
                    }
                    while (node != null && !node.isDisposed()) {
                        if (node instanceof TCFNodeExecContext) {
                            TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!cache.validate((Runnable)this)) {
                                return;
                            }
                            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)cache.getData();
                            if (ctx != null && ctx.canTerminate()) {
                                set.add(ctx);
                                break;
                            }
                            TCFChildren children_cache = ((TCFNodeExecContext)node).getChildren();
                            if (!children_cache.validate(this)) {
                                return;
                            }
                            TCFNode[] tCFNodeArray = children_cache.toArray();
                            int n = tCFNodeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TCFNode child = tCFNodeArray[n2];
                                cache = ((TCFNodeExecContext)child).getRunContext();
                                if (!cache.validate((Runnable)this)) {
                                    return;
                                }
                                IRunControl.RunControlContext child_ctx = (IRunControl.RunControlContext)cache.getData();
                                if (child_ctx != null && child_ctx.canTerminate()) {
                                    if (ctx != null) {
                                        set.add(ctx);
                                    } else {
                                        set.add(child_ctx);
                                    }
                                }
                                ++n2;
                            }
                            break;
                        }
                        node = node.getParent();
                    }
                    ++i;
                }
                final HashSet<IToken> cmds = new HashSet<IToken>();
                for (IRunControl.RunControlContext ctx : set) {
                    cmds.add(ctx.terminate(new IRunControl.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (!$assertionsDisabled && !cmds.contains(token)) {
                                throw new AssertionError();
                            }
                            cmds.remove(token);
                            if (error != null) {
                                monitor.setStatus((IStatus)new Status(4, "org.eclipse.tcf.debug.ui", 0, "Cannot resume: " + error.getLocalizedMessage(), (Throwable)error));
                            }
                            if (cmds.isEmpty()) {
                                this.done();
                            }
                        }
                    }));
                }
            }
        };
        return false;
    }
}

