/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StyledStringBuffer {
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int MONOSPACED = 4;
    private final StringBuffer bf = new StringBuffer();
    private final ArrayList<Style> styles = new ArrayList();

    StyledStringBuffer() {
    }

    StyledStringBuffer append(int pos, int font, RGB bg, RGB fg) {
        Style x = new Style();
        x.pos = pos;
        x.len = this.bf.length() - pos;
        x.font = font;
        x.bg = bg;
        x.fg = fg;
        this.styles.add(x);
        return this;
    }

    StyledStringBuffer append(String s) {
        this.bf.append(s);
        return this;
    }

    StyledStringBuffer append(char ch) {
        this.bf.append(ch);
        return this;
    }

    StyledStringBuffer append(int i) {
        this.bf.append(i);
        return this;
    }

    StyledStringBuffer append(String s, int font) {
        Style x = new Style();
        x.pos = this.bf.length();
        x.len = s.length();
        x.font = font;
        this.styles.add(x);
        this.bf.append(s);
        return this;
    }

    StyledStringBuffer append(String s, int font, RGB bg, RGB fg) {
        Style x = new Style();
        x.pos = this.bf.length();
        x.len = s.length();
        x.font = font;
        x.bg = bg;
        x.fg = fg;
        this.styles.add(x);
        this.bf.append(s);
        return this;
    }

    StyledStringBuffer append(StyledStringBuffer s) {
        int offs = this.bf.length();
        for (Style y : s.styles) {
            Style x = new Style();
            x.pos = y.pos + offs;
            x.len = y.len;
            x.font = y.font;
            x.bg = y.bg;
            x.fg = y.fg;
            this.styles.add(x);
        }
        this.bf.append(s.bf);
        return this;
    }

    StyledStringBuffer append(Throwable x, RGB color) {
        String[] a;
        if (x == null) {
            return this;
        }
        String[] stringArray = a = ("Exception: " + TCFModel.getErrorMessage(x, true)).split("\n");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int i = s.indexOf(58);
            if (i >= 0) {
                this.append(s.substring(0, i + 1), 1, null, color);
                this.append(s.substring(i + 1), 2, null, color);
            } else {
                this.append(s, 2, null, color);
            }
            this.bf.append('\n');
            ++n2;
        }
        return this;
    }

    StringBuffer getStringBuffer() {
        return this.bf;
    }

    Collection<Style> getStyle() {
        return this.styles;
    }

    int length() {
        return this.bf.length();
    }

    public String toString() {
        return this.bf.toString();
    }

    static class Style {
        int pos;
        int len;
        int font;
        RGB bg;
        RGB fg;

        Style() {
        }
    }
}

