/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;

public class TCFNodeArrayPartition
extends TCFNode {
    private final int offs;
    private final int size;
    private final TCFChildrenSubExpressions children;

    TCFNodeArrayPartition(TCFNode parent, int level, int offs, int size) {
        super(parent, "AP" + level + "." + offs + "." + parent.id);
        this.offs = offs;
        this.size = size;
        this.children = new TCFChildrenSubExpressions(this, level, offs, size);
    }

    int getOffset() {
        return this.offs;
    }

    int getSize() {
        return this.size;
    }

    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    protected boolean getData(IChildrenUpdate result, Runnable done) {
        return this.children.getData(result, done);
    }

    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        result.setHasChilren(true);
        return true;
    }

    protected boolean getData(ILabelUpdate result, Runnable done) {
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/arraypartition_obj.gif"), 0);
        String[] cols = result.getColumnIds();
        String name = "[" + this.offs + ".." + (this.offs + this.size - 1) + "]";
        if (cols == null || cols.length <= 1) {
            result.setLabel(name, 0);
        } else {
            int i = 0;
            while (i < cols.length) {
                String c = cols[i];
                if (c.equals("Name")) {
                    result.setLabel(name, i);
                } else {
                    result.setLabel("", i);
                }
                ++i;
            }
        }
        return true;
    }

    void onSuspended(boolean func_call) {
        this.children.onSuspended(func_call);
    }

    void onValueChanged() {
        this.children.onValueChanged();
    }

    void onRegisterValueChanged() {
        this.children.onRegisterValueChanged();
    }

    void onMemoryChanged() {
        this.children.onMemoryChanged();
    }

    void onMemoryMapChanged() {
        this.children.onMemoryMapChanged();
    }

    public int compareTo(TCFNode n) {
        TCFNodeArrayPartition p = (TCFNodeArrayPartition)n;
        if (this.offs < p.offs) {
            return -1;
        }
        if (this.offs > p.offs) {
            return 1;
        }
        return 0;
    }
}

