/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.protocol.Protocol;

class TCFSnapshot {
    private final IPresentationContext ctx;
    private final HashMap<TCFNode, PresentationData> cache = new HashMap();
    private final String[] columns;
    private boolean ignore_bg_color = true;
    private PresentationData data;

    TCFSnapshot(IPresentationContext ctx) {
        this.ctx = ctx;
        this.columns = ctx.getColumns();
    }

    void dispose() {
        for (PresentationData d : this.cache.values()) {
            for (Runnable r : d.waiting_list) {
                Protocol.invokeLater((Runnable)r);
            }
        }
        this.cache.clear();
    }

    public boolean getData(IChildrenCountUpdate update, TCFNode node, Runnable done) {
        if (!this.getChildren((IViewerUpdate)update, node, done)) {
            return false;
        }
        update.setChildCount(this.data.children.length);
        return true;
    }

    public boolean getData(IChildrenUpdate update, TCFNode node, Runnable done) {
        if (!this.getChildren((IViewerUpdate)update, node, done)) {
            return false;
        }
        int offset = 0;
        int r_offset = update.getOffset();
        int r_length = update.getLength();
        TCFNode[] tCFNodeArray = this.data.children;
        int n = this.data.children.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                update.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    public boolean getData(IHasChildrenUpdate update, TCFNode node, Runnable done) {
        if (!this.getChildren((IViewerUpdate)update, node, done)) {
            return false;
        }
        update.setHasChilren(this.data.children.length > 0);
        return true;
    }

    public boolean getData(ILabelUpdate update, TCFNode node, Runnable done) {
        block20: {
            int i;
            Object[] ids_update;
            block19: {
                Object[] ids_data;
                if (!this.getLabel((IViewerUpdate)update, node, done)) {
                    return false;
                }
                ids_update = update.getColumnIds();
                if (ids_update == (ids_data = this.columns) || Arrays.equals(ids_update, ids_data)) break block19;
                int n = ids_update == null ? 1 : ids_update.length;
                int i2 = 0;
                while (i2 < n) {
                    update.setBackground(ColorCache.rgb_stalled, i2);
                    ++i2;
                }
                break block20;
            }
            if (this.data.label != null) {
                i = 0;
                while (i < this.data.label.length) {
                    if (this.data.label[i] != null) {
                        update.setLabel(this.data.label[i], i);
                    }
                    ++i;
                }
            }
            if (this.data.font_data != null) {
                i = 0;
                while (i < this.data.font_data.length) {
                    if (this.data.font_data[i] != null) {
                        update.setFontData(this.data.font_data[i], i);
                    }
                    ++i;
                }
            }
            if (this.data.image_desc != null) {
                i = 0;
                while (i < this.data.image_desc.length) {
                    if (this.data.image_desc[i] != null) {
                        update.setImageDescriptor(this.data.image_desc[i], i);
                    }
                    ++i;
                }
            }
            if (this.data.isStalled()) {
                int n = ids_update == null ? 1 : ids_update.length;
                int i3 = 0;
                while (i3 < n) {
                    update.setForeground(ColorCache.rgb_stalled, i3);
                    ++i3;
                }
            } else if (this.data.fg_color != null) {
                i = 0;
                while (i < this.data.fg_color.length) {
                    if (this.data.fg_color[i] != null) {
                        update.setForeground(this.data.fg_color[i], i);
                    }
                    ++i;
                }
            }
            if (this.ignore_bg_color || this.data.bg_color == null) break block20;
            i = 0;
            while (i < this.data.bg_color.length) {
                if (this.data.bg_color[i] != null) {
                    update.setBackground(this.data.bg_color[i], i);
                }
                ++i;
            }
        }
        return true;
    }

    private boolean getChildren(IViewerUpdate update, TCFNode node, Runnable done) {
        this.data = this.cache.get(node);
        if (this.data == null) {
            this.data = new PresentationData();
            this.cache.put(node, this.data);
        }
        assert (this.data.update != update);
        if (this.data.children_done) {
            return true;
        }
        if (this.data.update != null) {
            this.data.waiting_list.add(done);
            return false;
        }
        this.data.update = update;
        this.data.done = done;
        if (this.data.children == null) {
            if (!node.getData(this.data, (Runnable)this.data)) {
                return false;
            }
            assert (this.data.children != null);
        }
        if (!node.getData(this.data, (Runnable)this.data)) {
            return false;
        }
        this.data.children_done = true;
        this.data.update = null;
        this.data.done = null;
        return true;
    }

    private boolean getLabel(IViewerUpdate update, TCFNode node, Runnable done) {
        this.data = this.cache.get(node);
        if (this.data == null) {
            this.data = new PresentationData();
            this.cache.put(node, this.data);
        }
        assert (this.data.update != update);
        if (this.data.update != null) {
            this.data.waiting_list.add(done);
            return false;
        }
        this.data.update = update;
        this.data.done = done;
        if (!node.getData(this.data, (Runnable)this.data)) {
            return false;
        }
        this.data.label_done = true;
        this.data.update = null;
        this.data.done = null;
        return true;
    }

    private class PresentationData
    implements IChildrenCountUpdate,
    IChildrenUpdate,
    ILabelUpdate,
    Runnable {
        IViewerUpdate update;
        Runnable done;
        boolean canceled;
        IStatus status;
        String[] label;
        String[] label_next;
        FontData[] font_data;
        ImageDescriptor[] image_desc;
        RGB[] fg_color;
        RGB[] bg_color;
        boolean label_done;
        TCFNode[] children;
        boolean children_done;
        private final ArrayList<Runnable> waiting_list = new ArrayList();

        private PresentationData() {
        }

        boolean isStalled() {
            if (this.label == null) {
                return false;
            }
            if (this.label_next == null) {
                return false;
            }
            return !Arrays.equals(this.label, this.label_next);
        }

        public IPresentationContext getPresentationContext() {
            return TCFSnapshot.this.ctx;
        }

        public Object getElement() {
            return this.update.getElement();
        }

        public TreePath getElementPath() {
            return this.update.getElementPath();
        }

        public Object getViewerInput() {
            return this.update.getViewerInput();
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void done() {
            assert (false);
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public String[] getColumnIds() {
            return TCFSnapshot.this.columns;
        }

        public void setLabel(String text, int col) {
            if (!this.label_done) {
                if (this.label == null) {
                    int cnt = TCFSnapshot.this.columns == null ? 1 : TCFSnapshot.this.columns.length;
                    this.label = new String[cnt];
                }
                this.label[col] = text;
            } else {
                if (this.label_next == null) {
                    int cnt = TCFSnapshot.this.columns == null ? 1 : TCFSnapshot.this.columns.length;
                    this.label_next = new String[cnt];
                }
                this.label_next[col] = text;
            }
        }

        public void setFontData(FontData fnt, int col) {
            if (!this.label_done) {
                if (this.font_data == null) {
                    int cnt = TCFSnapshot.this.columns == null ? 1 : TCFSnapshot.this.columns.length;
                    this.font_data = new FontData[cnt];
                }
                this.font_data[col] = fnt;
            }
        }

        public void setImageDescriptor(ImageDescriptor image, int col) {
            if (!this.label_done) {
                if (this.image_desc == null) {
                    int cnt = TCFSnapshot.this.columns == null ? 1 : TCFSnapshot.this.columns.length;
                    this.image_desc = new ImageDescriptor[cnt];
                }
                this.image_desc[col] = image;
            }
        }

        public void setForeground(RGB rgb, int col) {
            if (!this.label_done) {
                if (this.fg_color == null) {
                    int cnt = TCFSnapshot.this.columns == null ? 1 : TCFSnapshot.this.columns.length;
                    this.fg_color = new RGB[cnt];
                }
                this.fg_color[col] = rgb;
            }
        }

        public void setBackground(RGB rgb, int col) {
            if (!this.label_done) {
                if (this.bg_color == null) {
                    int cnt = TCFSnapshot.this.columns == null ? 1 : TCFSnapshot.this.columns.length;
                    this.bg_color = new RGB[cnt];
                }
                this.bg_color[col] = rgb;
            }
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return this.children.length;
        }

        public void setChild(Object child, int offset) {
            if (!this.children_done) {
                this.children[offset] = (TCFNode)child;
            }
        }

        public void setChildCount(int cnt) {
            if (!this.children_done) {
                this.children = new TCFNode[cnt];
            }
        }

        public void run() {
            Runnable d = this.done;
            this.update = null;
            this.done = null;
            for (Runnable r : this.waiting_list) {
                Protocol.invokeLater((Runnable)r);
            }
            this.waiting_list.clear();
            d.run();
        }
    }
}

