/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.selection;

import java.util.ArrayList;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;

public class LaunchSelection
implements ILaunchSelection {
    private String mode;
    private ISelectionContext[] contexts;

    public LaunchSelection(String mode, ISelectionContext context) {
        ISelectionContext[] iSelectionContextArray;
        if (context != null) {
            ISelectionContext[] iSelectionContextArray2 = new ISelectionContext[1];
            iSelectionContextArray = iSelectionContextArray2;
            iSelectionContextArray2[0] = context;
        } else {
            iSelectionContextArray = null;
        }
        this(mode, iSelectionContextArray);
    }

    public LaunchSelection(String mode, ISelectionContext[] contexts) {
        this.contexts = null;
        this.mode = mode;
        this.contexts = contexts;
    }

    @Override
    public final String getLaunchMode() {
        return this.mode;
    }

    @Override
    public ISelectionContext[] getSelectedContexts() {
        return this.contexts != null ? this.contexts : new ISelectionContext[]{};
    }

    @Override
    public ISelectionContext[] getSelectedContexts(Class<?> type) {
        ArrayList<ISelectionContext> contexts = new ArrayList<ISelectionContext>();
        ISelectionContext[] iSelectionContextArray = this.getSelectedContexts();
        int n = iSelectionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionContext selectionContext = iSelectionContextArray[n2];
            if (type.isInstance(selectionContext)) {
                contexts.add(selectionContext);
            }
            ++n2;
        }
        return contexts.toArray(new ISelectionContext[contexts.size()]);
    }

    public boolean equals(Object obj) {
        boolean equals = obj instanceof ILaunchSelection;
        if (equals) {
            ILaunchSelection otherSelection = (ILaunchSelection)obj;
            equals &= this.mode == null && otherSelection.getLaunchMode() == null || this.mode != null && this.mode.equals(otherSelection.getLaunchMode());
            ISelectionContext[] c1 = this.getSelectedContexts();
            ISelectionContext[] c2 = otherSelection.getSelectedContexts();
            equals &= c1.length == c2.length;
            int i = 0;
            while (equals && i < c1.length) {
                equals &= c1[i].equals(c2[i]);
                ++i;
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.mode != null) {
            hashCode = this.mode.hashCode() << 16;
        }
        ISelectionContext[] iSelectionContextArray = this.getSelectedContexts();
        int n = iSelectionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionContext context = iSelectionContextArray[n2];
            hashCode ^= context.hashCode();
            ++n2;
        }
        return hashCode;
    }
}

