/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.handler;

import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.selection.LaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.ProjectSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.selection.LaunchSelectionManager;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class NewLaunchConfigurationContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private boolean enabled = true;
    private IServiceLocator serviceLocator;

    public NewLaunchConfigurationContributionItem() {
    }

    public NewLaunchConfigurationContributionItem(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected IContributionItem[] getContributionItems() {
        LaunchNode node;
        ILaunchConfigurationType type;
        IHandlerService service = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        IEvaluationContext state = service.getCurrentState();
        ISelection selection = (ISelection)state.getVariable("selection");
        IStructuredSelection iss = (IStructuredSelection)selection;
        Object obj = iss.getFirstElement();
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        if (obj instanceof LaunchNode && (type = (node = (LaunchNode)((Object)obj)).getLaunchConfigurationType()) != null) {
            try {
                String[] stringArray = LaunchConfigHelper.getLaunchConfigTypeModes((ILaunchConfigurationType)type, (boolean)false);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList<Object> selectionContexts;
                    String mode = stringArray[n2];
                    ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(type, mode);
                    ILaunchSelection launchSelection = null;
                    if (node.getModel().getModelRoot() instanceof ICategory) {
                        launchSelection = LaunchSelectionManager.getInstance().getLaunchSelection(type, mode, "org.eclipse.tcf.te.ui.views.View");
                    } else if (node.getModel().getModelRoot() instanceof IModelNode) {
                        selectionContexts = new ArrayList<Object>();
                        selectionContexts.add(new RemoteSelectionContext((IModelNode)node.getModel().getModelRoot(), true));
                        selectionContexts.addAll(LaunchSelectionManager.getInstance().getSelectionContextsFor("org.eclipse.ui.navigator.ProjectExplorer", type, mode, false));
                        launchSelection = new LaunchSelection(mode, selectionContexts.toArray(new ISelectionContext[selectionContexts.size()]));
                    } else if (node.getModel().getModelRoot() instanceof IProject) {
                        selectionContexts = new ArrayList();
                        selectionContexts.add(new ProjectSelectionContext((IProject)node.getModel().getModelRoot(), true));
                        selectionContexts.addAll(LaunchSelectionManager.getInstance().getSelectionContextsFor("org.eclipse.tcf.te.ui.views.View", type, mode, false));
                        launchSelection = new LaunchSelection(mode, selectionContexts.toArray(new ISelectionContext[selectionContexts.size()]));
                    }
                    if (launchSelection != null) {
                        final ILaunchSpecification launchSpec = delegate.getLaunchSpecification(type.getIdentifier(), launchSelection);
                        final ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)type.newInstance(null, "temp"), (String)mode);
                        ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
                        Action action = new Action(){

                            public void run() {
                                try {
                                    ILaunchConfiguration config = LaunchManager.getInstance().createOrUpdateLaunchConfiguration(null, launchSpec);
                                    DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)config), (String)launchGroup.getIdentifier());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        action.setText(String.valueOf(launchMode.getLabel()) + " Configuration");
                        action.setImageDescriptor(launchGroup.getImageDescriptor());
                        items.add(new ActionContributionItem((IAction)action));
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.enabled = !items.isEmpty();
        return items.toArray(new IContributionItem[items.size()]);
    }
}

