/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.viewer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;

public class LaunchNodeImageDescriptor
extends AbstractImageDescriptor {
    private Image baseImage;
    private Point imageSize;
    private boolean isValid;

    public LaunchNodeImageDescriptor(ImageRegistry registry, Image baseImage, LaunchNode node) {
        super(registry);
        this.baseImage = baseImage;
        this.imageSize = new Point(baseImage.getImageData().width, baseImage.getImageData().height);
        this.initialize(node);
        this.defineKey(baseImage.hashCode());
    }

    protected void initialize(LaunchNode node) {
        Assert.isNotNull((Object)((Object)node));
        this.isValid = node.isValidFor(null);
    }

    protected void defineKey(int hashCode) {
        String key = "LaunchNodeID:" + hashCode + ":" + this.isValid;
        this.setDecriptorKey(key);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawCentered(this.baseImage, width, height);
        if (!this.isValid) {
            this.drawBottomRight("RedXOverlay");
        }
    }

    protected Point getSize() {
        return this.imageSize;
    }

    protected Image getBaseImage() {
        return this.baseImage;
    }
}

