/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.tabs.launchcontext;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.launch.ui.tabs.launchcontext.AbstractContextSelectorControl;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractContextSelectorSection
extends AbstractSection
implements ILaunchConfigurationTabFormPart {
    AbstractContextSelectorControl selector;

    public AbstractContextSelectorSection(IManagedForm form, Composite parent) {
        super(form, parent, 66);
        this.getSection().setBackground(parent.getBackground());
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.ContextSelectorSection_title);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite client = this.createClientContainer((Composite)section, 1, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        client.setBackground(section.getBackground());
        this.createSectionToolbar(section, toolkit);
        this.selector = this.doCreateContextSelector();
        this.selector.setFormToolkit(toolkit);
        this.selector.setupPanel(client);
        this.setIsUpdating(false);
    }

    protected abstract AbstractContextSelectorControl doCreateContextSelector();

    public void dispose() {
        if (this.selector != null) {
            this.selector.dispose();
            this.selector = null;
        }
        super.dispose();
    }

    protected void createSectionToolbarItems(Section section, FormToolkit toolkit, ToolBarManager tlbMgr) {
        super.createSectionToolbarItems(section, toolkit, tlbMgr);
        tlbMgr.add((IAction)new RefreshAction());
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        IModelNode[] contexts;
        Assert.isNotNull((Object)configuration);
        if (this.selector != null && (contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)configuration)) != null && contexts.length > 0) {
            ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
            IModelNode[] iModelNodeArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IModelNode node = iModelNodeArray[n2];
                if (node != null && !nodes.contains(node)) {
                    nodes.add(node);
                }
                ++n2;
            }
            if (!nodes.isEmpty()) {
                this.selector.setCheckedModelContexts(nodes.toArray(new IModelNode[nodes.size()]));
            }
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Assert.isNotNull((Object)configuration);
        if (this.selector != null) {
            IModelNode[] nodes = this.selector.getCheckedModelContexts();
            if (nodes != null && nodes.length > 0) {
                LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)configuration, (IModelNode[])nodes);
            } else {
                LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)configuration, null);
            }
        } else {
            LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)configuration, null);
        }
    }

    @Override
    public boolean isValid(ILaunchConfiguration configuration) {
        boolean valid = super.isValid();
        if (valid && !(valid = this.selector.isValid())) {
            this.setMessage(this.selector.getMessage(), this.selector.getMessageType());
        }
        return valid;
    }

    protected class RefreshAction
    extends Action {
        public RefreshAction() {
            super(null, 1);
            this.setImageDescriptor(UIPlugin.getImageDescriptor("RefreshAction_enabled"));
            this.setToolTipText(Messages.ContextSelectorControl_toolbar_refresh_tooltip);
        }

        public void run() {
            if (AbstractContextSelectorSection.this.selector != null && AbstractContextSelectorSection.this.selector.getViewer() != null) {
                AbstractContextSelectorSection.this.selector.getViewer().refresh();
            }
        }
    }
}

