/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.va;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.eclipse.tcf.te.tcf.core.va.AbstractValueAdd;
import org.eclipse.tcf.te.tcf.core.va.ValueAddLauncher;

public abstract class AbstractExternalValueAdd
extends AbstractValueAdd {
    final Map<String, ValueAddEntry> entries = new HashMap<String, ValueAddEntry>();

    @Override
    public IPeer getPeer(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        IPeer peer = null;
        ValueAddEntry entry = this.entries.get(id);
        if (entry != null) {
            peer = entry.peer;
        }
        return peer;
    }

    @Override
    public void isAlive(final String id, final ICallback done) {
        String[] attrs;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)done);
        done.setResult((Object)Boolean.FALSE);
        ValueAddEntry entry = this.entries.get(id);
        if (entry == null && this.getDebugPeerId() != null && (attrs = this.getDebugPeerId().split(":")).length == 3) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("ID", this.getDebugPeerId());
            props.put("TransportName", attrs[0]);
            if (attrs[1].length() > 0) {
                props.put("Host", attrs[1]);
            } else {
                props.put("Host", IPAddressUtil.getInstance().getIPv4LoopbackAddress());
            }
            props.put("Port", attrs[2]);
            entry = new ValueAddEntry();
            entry.peer = new TransientPeer(props);
            this.entries.put(id, entry);
        }
        if (entry != null) {
            boolean exited = false;
            if (entry.process != null) {
                Assert.isNotNull((Object)entry.peer);
                try {
                    entry.process.exitValue();
                    exited = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
            if (!exited) {
                final ValueAddEntry finEntry = entry;
                final IChannel channel = entry.peer.openChannel();
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        channel.removeChannelListener((IChannel.IChannelListener)this);
                        channel.close();
                        done.setResult((Object)Boolean.TRUE);
                        done.done((Object)AbstractExternalValueAdd.this, Status.OK_STATUS);
                    }

                    public void onChannelClosed(Throwable error) {
                        channel.removeChannelListener((IChannel.IChannelListener)this);
                        AbstractExternalValueAdd.this.entries.remove(id);
                        if (finEntry.process != null) {
                            finEntry.process.destroy();
                        }
                        done.done((Object)AbstractExternalValueAdd.this, Status.OK_STATUS);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            } else {
                done.done((Object)this, Status.OK_STATUS);
            }
        } else {
            done.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public void launch(String id, ICallback done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)done);
        Throwable error = null;
        IPath path = this.getLocation();
        if (path != null && path.toFile().canRead()) {
            ValueAddLauncher launcher = this.createLauncher(id, path);
            try {
                launcher.launch();
            }
            catch (Throwable e) {
                error = e;
            }
            ValueAddEntry entry = new ValueAddEntry();
            if (error == null) {
                Process process = launcher.getProcess();
                try {
                    int exitCode = process.exitValue();
                    error = new IOException("Value-add process died with exit code " + exitCode);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    entry.process = process;
                }
            }
            String output = null;
            if (error == null) {
                int counter = 10;
                while (counter > 0 && output == null) {
                    output = launcher.getOutputReader().getOutput();
                    if ("".equals(output)) {
                        output = null;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    --counter;
                }
                if (output == null) {
                    error = new IOException("Failed to read output from value-add.");
                }
            }
            HashMap<String, String> attrs = null;
            if (error == null) {
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.AbstractExternalValueAdd_output, (Object)output, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                }
                output = output.replace("Server-Properties:", " ");
                output = output.trim();
                Object object = null;
                try {
                    object = JSON.parseOne((byte[])output.getBytes("UTF-8"));
                    attrs = new HashMap<String, String>((Map)object);
                }
                catch (IOException e) {
                    error = e;
                }
            }
            if (error == null) {
                String transport = (String)attrs.get("TransportName");
                String port = (String)attrs.get("Port");
                String ip = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
                if (transport != null && ip != null && port != null) {
                    String peerId = String.valueOf(transport) + ":" + ip + ":" + port;
                    attrs.put("ID", peerId);
                    attrs.put("Host", ip);
                    entry.peer = new TransientPeer(attrs);
                } else {
                    error = new IOException("Invalid or incomplete peer attributes reported by value-add.");
                }
            }
            if (error == null) {
                Assert.isNotNull((Object)entry.process);
                Assert.isNotNull((Object)entry.peer);
                this.entries.put(id, entry);
            }
        } else {
            error = new FileNotFoundException(NLS.bind((String)Messages.AbstractExternalValueAdd_error_invalidLocation, (Object)this.getId()));
        }
        IStatus status = Status.OK_STATUS;
        if (error != null) {
            status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), error);
        }
        done.done((Object)this, status);
    }

    protected abstract IPath getLocation();

    protected ValueAddLauncher createLauncher(String id, IPath path) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)path);
        return new ValueAddLauncher(id, path, this.getLabel() != null ? this.getLabel() : this.getId());
    }

    @Override
    public void shutdown(final String id, final ICallback done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)done);
        final ValueAddEntry entry = this.entries.get(id);
        if (entry != null) {
            this.isAlive(id, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    boolean alive = (Boolean)this.getResult();
                    if (alive) {
                        AbstractExternalValueAdd.this.entries.remove(id);
                        if (entry.process != null) {
                            entry.process.destroy();
                        }
                    }
                    done.done((Object)AbstractExternalValueAdd.this, Status.OK_STATUS);
                }
            });
        } else {
            done.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public void shutdownAll(ICallback done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)done);
        AsyncCallbackCollector collector = new AsyncCallbackCollector(done, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        for (String id : this.entries.keySet()) {
            AsyncCallbackCollector.SimpleCollectorCallback callback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
            this.shutdown(id, (ICallback)callback);
        }
        collector.initDone();
    }

    protected static class ValueAddEntry {
        public Process process;
        public IPeer peer;

        protected ValueAddEntry() {
        }
    }
}

