/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.CallbackBase;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class QueryDoneReadDir
extends CallbackBase
implements IFileSystem.DoneReadDir {
    IChannel channel;
    IFileSystem service;
    IFileSystem.IFileHandle handle;
    FSTreeNode parentNode;
    ICallback callback;

    public QueryDoneReadDir(ICallback callback, IChannel channel, IFileSystem service, IFileSystem.IFileHandle handle, FSTreeNode parentNode) {
        this.callback = callback;
        this.channel = channel;
        this.service = service;
        this.handle = handle;
        this.parentNode = parentNode;
    }

    public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
        if (error == null) {
            if (entries != null && entries.length > 0) {
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileSystem.DirEntry entry = dirEntryArray[n2];
                    FSTreeNode node = new FSTreeNode(this.parentNode, entry, false);
                    this.parentNode.addChild(node);
                    ++n2;
                }
            }
            if (eof) {
                this.service.close(this.handle, new IFileSystem.DoneClose(){

                    public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                        if (QueryDoneReadDir.this.callback != null) {
                            IStatus status = error == null ? Status.OK_STATUS : new Status(4, CorePlugin.getUniqueIdentifier(), error.getMessage(), (Throwable)error);
                            QueryDoneReadDir.this.callback.done((Object)this, status);
                        }
                    }
                });
            } else {
                this.service.readdir(this.handle, (IFileSystem.DoneReadDir)new QueryDoneReadDir(this.callback, this.channel, this.service, this.handle, this.parentNode));
            }
        } else if (this.callback != null) {
            Status status = new Status(4, CorePlugin.getUniqueIdentifier(), this.getErrorMessage((Throwable)error), (Throwable)error);
            this.callback.done((Object)this, (IStatus)status);
        }
    }
}

