/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRefreshRoots;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.ui.interfaces.ILazyLoader;

public class FSTreeNodeLoader
implements ILazyLoader {
    private FSTreeNode node;

    public FSTreeNodeLoader(FSTreeNode node) {
        this.node = node;
    }

    public boolean isDataLoaded() {
        return (this.node.isSystemRoot() || this.node.isDirectory()) && this.node.childrenQueried;
    }

    public void loadData(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            if (this.node.isFile()) {
                return;
            }
            if (this.node.isSystemRoot()) {
                new NullOpExecutor().execute((IOperation)new OpRefreshRoots(this.node));
            } else {
                new Operation().getChildren(this.node);
            }
        }
        catch (TCFException e) {
            throw new InvocationTargetException(e);
        }
    }
}

