/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.ui.connector;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.terminals.core.interfaces.launcher.ITerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.ui.connector.TerminalsSettings;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.types.AbstractConnectorType;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;

public class TerminalsConnectorType
extends AbstractConnectorType {
    public ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        Assert.isNotNull((Object)properties);
        String connectorId = properties.getStringProperty("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tcf.te.tcf.terminals.ui.TerminalsConnector";
        }
        OutputStream stdin = (OutputStream)properties.getProperty("streams.stdin");
        InputStream stdout = (InputStream)properties.getProperty("streams.stdout");
        InputStream stderr = (InputStream)properties.getProperty("streams.stderr");
        boolean localEcho = properties.getBooleanProperty("localEcho");
        String lineSeparator = properties.getStringProperty("lineSeparator");
        ITerminalsLauncher launcher = (ITerminalsLauncher)properties.getProperty("data");
        SettingsStore store = new SettingsStore();
        TerminalsSettings terminalsSettings = new TerminalsSettings();
        terminalsSettings.setStdinStream(stdin);
        terminalsSettings.setStdoutStream(stdout);
        terminalsSettings.setStderrStream(stderr);
        terminalsSettings.setLocalEcho(localEcho);
        terminalsSettings.setLineSeparator(lineSeparator);
        terminalsSettings.setTerminalsLauncher(launcher);
        terminalsSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

