/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal.adapters;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;

public class CategorizableAdapter
implements ICategorizable {
    final Object element;

    public CategorizableAdapter(Object element) {
        Assert.isNotNull((Object)element);
        this.element = element;
    }

    public String getId() {
        if (this.element instanceof IPeerModel) {
            return ((IPeerModel)this.element).getPeerId();
        }
        return null;
    }

    public boolean isValid(ICategorizable.OPERATION operation, ICategory parentCategory, ICategory category) {
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)category);
        if (this.element instanceof IPeerModel) {
            if (ICategorizable.OPERATION.ADD.equals((Object)operation) && category.equals(parentCategory)) {
                return false;
            }
            if ("org.eclipse.tcf.te.ui.views.category.mytargets".equals(category.getId())) {
                final AtomicBoolean isStatic = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String value = (String)((IPeerModel)CategorizableAdapter.this.element).getPeer().getAttributes().get("static.transient");
                        isStatic.set(value != null && Boolean.parseBoolean(value.trim()));
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                if (isStatic.get()) {
                    return false;
                }
            }
            return !"org.eclipse.tcf.te.ui.views.category.neighborhood".equals(category.getId());
        }
        return false;
    }

    public boolean isEnabled(ICategorizable.OPERATION operation, ICategory category) {
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)category);
        if (this.element instanceof IPeerModel) {
            if (ICategorizable.OPERATION.ADD.equals((Object)operation) && Managers.getCategoryManager().belongsTo(category.getId(), this.getId())) {
                return false;
            }
            return !ICategorizable.OPERATION.REMOVE.equals((Object)operation) || Managers.getCategoryManager().belongsTo(category.getId(), this.getId());
        }
        return false;
    }
}

