/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.file;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.tcf.te.ui.controls.BaseDialogSelectionControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.FileNameValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class FileSelectionControl
extends BaseDialogSelectionControl {
    private String[] filterExtensions;
    private String[] filterNames;

    public FileSelectionControl(IDialogPage parentPage) {
        super(parentPage);
        this.setDialogTitle(Messages.FileSelectionControl_title_open);
        this.setGroupLabel(Messages.FileSelectionControl_group_label);
        this.setEditFieldLabel(Messages.FileSelectionControl_editfield_label);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
        if (this.getEditFieldValidator() != null && filterExtensions != null) {
            ((FileNameValidator)this.getEditFieldValidator()).setFileExtensions(filterExtensions);
        }
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    @Override
    protected Dialog doCreateDialogControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        FileDialog dialog = new FileDialog(parent.getShell(), 4096);
        return dialog;
    }

    @Override
    protected void configureDialogControl(Dialog dialog) {
        super.configureDialogControl(dialog);
        if (dialog instanceof FileDialog) {
            String selectedFile;
            FileDialog fileDialog = (FileDialog)dialog;
            if (this.getFilterExtensions() != null) {
                fileDialog.setFilterExtensions(this.getFilterExtensions());
            }
            if (this.getFilterNames() != null) {
                fileDialog.setFilterNames(this.getFilterNames());
            }
            if ((selectedFile = this.doGetSelectedFile()) != null && selectedFile.trim().length() > 0) {
                String filterFileName;
                Path filePath = new Path(selectedFile);
                Path filterPath = filePath.toFile().isDirectory() ? filePath : filePath.removeLastSegments(1);
                String string = filterFileName = filePath.toFile().isDirectory() || !filePath.toFile().exists() ? null : filePath.lastSegment();
                if (!filterPath.isEmpty()) {
                    fileDialog.setFilterPath(filterPath.toString());
                }
                if (filterFileName != null) {
                    fileDialog.setFileName(filterFileName);
                }
            } else if (Platform.getBundle((String)"org.eclipse.core.resources") != null && Platform.getBundle((String)"org.eclipse.core.resources").getState() == 32) {
                fileDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
        }
    }

    protected String doGetSelectedFile() {
        return this.getEditFieldControlText();
    }

    @Override
    protected Validator doCreateEditFieldValidator() {
        return new FileNameValidator(15);
    }

    @Override
    protected void configureEditFieldValidator(Validator editFieldValidator) {
        if (editFieldValidator instanceof FileNameValidator && this.getFilterExtensions() != null) {
            ((FileNameValidator)editFieldValidator).setFileExtensions(this.getFilterExtensions());
        }
    }

    @Override
    protected String doOpenDialogControl(Dialog dialog) {
        Assert.isNotNull((Object)dialog);
        if (dialog instanceof FileDialog) {
            FileDialog fileDialog = (FileDialog)dialog;
            return fileDialog.open();
        }
        return null;
    }
}

