/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class NameOrIPValidator
extends Validator {
    private static final String IP_CHARACTERS_REGEX = "[0-9\\.]+";
    public static final String IP_REGEX = "([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])(\\.([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){3}";
    private static final String NAME_CHARACTERS_REGEX = "[0-9a-zA-Z\\-_\\.]+";
    public static final String NAME_REGEX = "([a-zA-Z][a-zA-Z0-9]*((\\-|_)[a-zA-Z0-9]+)*)(\\.([a-zA-Z][a-zA-Z0-9]*((\\-|_)[a-zA-Z0-9]+)*))*";
    public static final String INFO_MISSING_NAME_OR_IP = "NameOrIPValidator_Information_MissingNameOrIP";
    public static final String INFO_MISSING_NAME = "NameOrIPValidator_Information_MissingName";
    public static final String INFO_MISSING_IP = "NameOrIPValidator_Information_MissingIP";
    public static final String INFO_CHECK_NAME = "NameOrIPValidator_Information_CheckName";
    public static final String ERROR_INVALID_NAME_OR_IP = "NameOrIPValidator_Error.InvalidNameOrIP";
    public static final String ERROR_INVALID_IP = "NameOrIPValidator_Error_InvalidIP";
    public static final String ERROR_INVALID_NAME = "NameOrIPValidator_Error_InvalidName";
    public static final int ATTR_NAME = 2;
    public static final int ATTR_IP = 4;
    public static final int ATTR_CHECK_AVAILABLE = 8;
    private boolean isIP;
    private boolean isName;

    public NameOrIPValidator(int attributes) {
        super(attributes);
    }

    @Override
    protected void init() {
        super.init();
        this.isIP = false;
        this.isName = false;
    }

    @Override
    public boolean isValid(String ipOrHostName) {
        this.init();
        if (ipOrHostName == null || ipOrHostName.trim().length() == 0) {
            if (this.isAttribute(1)) {
                if (this.isAttribute(4) && !this.isAttribute(2)) {
                    this.setMessage(this.getMessageText(INFO_MISSING_IP), this.getMessageTextType(INFO_MISSING_IP, 1));
                } else if (this.isAttribute(2) && !this.isAttribute(4)) {
                    this.setMessage(this.getMessageText(INFO_MISSING_NAME), this.getMessageTextType(INFO_MISSING_NAME, 1));
                } else {
                    this.setMessage(this.getMessageText(INFO_MISSING_NAME_OR_IP), this.getMessageTextType(INFO_MISSING_NAME_OR_IP, 1));
                }
                return false;
            }
            return true;
        }
        if ((ipOrHostName = ipOrHostName.trim()).matches(IP_CHARACTERS_REGEX)) {
            this.isIP = true;
            if (!this.isAttribute(4) && this.isAttribute(2)) {
                this.setMessage(this.getMessageText(ERROR_INVALID_NAME), this.getMessageTextType(ERROR_INVALID_NAME, 3));
            } else if (!ipOrHostName.matches(IP_REGEX)) {
                this.setMessage(this.getMessageText(ERROR_INVALID_IP), this.getMessageTextType(ERROR_INVALID_IP, 3));
            }
        } else if (ipOrHostName.matches(NAME_CHARACTERS_REGEX)) {
            this.isName = true;
            if (!this.isAttribute(2) && this.isAttribute(4)) {
                this.setMessage(this.getMessageText(ERROR_INVALID_IP), this.getMessageTextType(ERROR_INVALID_IP, 3));
            } else if (!ipOrHostName.matches(NAME_REGEX)) {
                this.setMessage(this.getMessageText(ERROR_INVALID_NAME), this.getMessageTextType(ERROR_INVALID_NAME, 3));
            } else if (this.isAttribute(8)) {
                this.setMessage(this.getMessageText(INFO_CHECK_NAME), this.getMessageTextType(INFO_CHECK_NAME, 1));
            }
        } else if (this.isAttribute(4) && !this.isAttribute(2)) {
            this.setMessage(this.getMessageText(ERROR_INVALID_IP), this.getMessageTextType(ERROR_INVALID_IP, 3));
        } else if (this.isAttribute(2) && !this.isAttribute(4)) {
            this.setMessage(this.getMessageText(ERROR_INVALID_NAME), this.getMessageTextType(ERROR_INVALID_NAME, 3));
        } else {
            this.setMessage(this.getMessageText(ERROR_INVALID_NAME_OR_IP), this.getMessageTextType(ERROR_INVALID_NAME_OR_IP, 3));
        }
        return this.getMessageType() != 3;
    }

    public boolean isIP() {
        return this.isIP;
    }

    public boolean isName() {
        return this.isName;
    }
}

