/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.jface.images;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractImageDescriptor
extends CompositeImageDescriptor {
    private final ImageRegistry parentImageRegistry;
    private String descriptorKey = null;

    public AbstractImageDescriptor(ImageRegistry parent) {
        Assert.isNotNull((Object)parent);
        this.parentImageRegistry = parent;
    }

    protected final ImageRegistry getParentImageRegistry() {
        return this.parentImageRegistry;
    }

    protected final void setDecriptorKey(String key) {
        Assert.isNotNull((Object)key);
        this.descriptorKey = key;
    }

    public final String getDecriptorKey() {
        return this.descriptorKey;
    }

    protected void drawCentered(String key, int width, int height) {
        Assert.isNotNull((Object)key);
        this.drawCentered(this.parentImageRegistry.get(key), width, height);
    }

    protected void drawCentered(Image image, int width, int height) {
        ImageData imageData;
        if (image != null && (imageData = image.getImageData()) != null) {
            int x = StrictMath.max(0, (width - imageData.width + 1) / 2);
            int y = StrictMath.max(0, (height - imageData.height + 1) / 2);
            this.drawImage(imageData, x, y);
        }
    }

    protected void drawCenterRight(String key, int width, int height) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            int x = StrictMath.max(0, width - imageData.width);
            int y = StrictMath.max(0, (height - imageData.height + 1) / 2);
            this.drawImage(imageData, x, y);
        }
    }

    protected void drawTopLeft(String key) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            this.drawImage(imageData, 0, 0);
        }
    }

    protected void drawTopRight(String key) {
        if (this.getSize() != null) {
            Point size = this.getSize();
            this.drawTopRight(key, size.x, size.y);
        } else {
            this.drawTopRight(key, 16, 16);
        }
    }

    protected void drawTopRight(String key, int width, int height) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            int x = StrictMath.max(0, width - imageData.width);
            this.drawImage(imageData, x, 0);
        }
    }

    protected void drawBottomCenter(String key, int width, int height) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            int x = StrictMath.max(0, (width - imageData.width + 1) / 2);
            int y = StrictMath.max(0, height - imageData.height);
            this.drawImage(imageData, x, y);
        }
    }

    protected void drawBottomLeft(String key, int width, int height) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            int y = StrictMath.max(0, height - imageData.height);
            this.drawImage(imageData, 0, y);
        }
    }

    protected void drawCenterLeft(String key, int width, int height) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            int y = StrictMath.max(0, (height - imageData.height) / 2);
            this.drawImage(imageData, 0, y);
        }
    }

    protected void drawBottomRight(String key) {
        if (this.getSize() != null) {
            Point size = this.getSize();
            this.drawBottomRight(key, size.x, size.y);
        } else {
            this.drawBottomRight(key, 16, 16);
        }
    }

    protected void drawBottomRight(String key, int width, int height) {
        ImageData imageData;
        Image image = this.parentImageRegistry.get(key);
        if (image != null && (imageData = image.getImageData()) != null) {
            int x = StrictMath.max(0, width - imageData.width);
            int y = StrictMath.max(0, height - imageData.height);
            this.drawImage(imageData, x, y);
        }
    }

    protected abstract Image getBaseImage();

    protected int getTransparentPixel() {
        Image baseImage = this.getBaseImage();
        if (baseImage != null && baseImage.getImageData() != null) {
            return baseImage.getImageData().transparentPixel;
        }
        return super.getTransparentPixel();
    }
}

