/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;

public class InputStreamMonitor
extends OutputStream
implements IDisposable {
    private final ITerminalControl terminalControl;
    private final OutputStream stream;
    private Thread thread;
    private boolean disposed;
    private final List<IDisposable> disposables = new ArrayList<IDisposable>();
    private final Queue<byte[]> queue = new LinkedList<byte[]>();
    private static final int TERMINAL_SENDS_CR = 0;
    private static final int TERMINAL_SENDS_CRLF = 1;
    private static final int PROGRAM_EXPECTS_LF = 0;
    private static final int PROGRAM_EXPECTS_CRLF = 1;
    private static final int PROGRAM_EXPECTS_CR = 2;
    private static final int NO_CHANGE = 0;
    private static final int CHANGE_CR_TO_LF = 1;
    private static final int INSERT_LF_AFTER_CR = 2;
    private static final int REMOVE_CR = 3;
    private static final int REMOVE_LF = 4;
    private static final int[][] CRLF_REPLACEMENT;
    private int replacement;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 3;
        nArray2[2] = 4;
        nArrayArray[1] = nArray2;
        CRLF_REPLACEMENT = nArrayArray;
    }

    public InputStreamMonitor(ITerminalControl terminalControl, OutputStream stream, boolean localEcho, String lineSeparator) {
        int terminalSends;
        Assert.isNotNull((Object)terminalControl);
        this.terminalControl = terminalControl;
        Assert.isNotNull((Object)stream);
        this.stream = stream;
        int n = terminalSends = localEcho ? 1 : 0;
        if (lineSeparator == null) {
            this.replacement = 0;
        } else {
            int programExpects = lineSeparator.equals("\\n") ? 0 : (lineSeparator.equals("\\r") ? 2 : 1);
            this.replacement = CRLF_REPLACEMENT[terminalSends][programExpects];
        }
    }

    public final void addDisposable(IDisposable disposable) {
        Assert.isNotNull((Object)disposable);
        if (!this.disposed && !this.disposables.contains(disposable)) {
            this.disposables.add(disposable);
        }
    }

    public final void removeDisposable(IDisposable disposable) {
        Assert.isNotNull((Object)disposable);
        this.disposables.remove(disposable);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.stream.close();
        }
        catch (IOException iOException) {}
        this.close();
        for (IDisposable disposable : this.disposables) {
            disposable.dispose();
        }
        this.disposables.clear();
    }

    @Override
    public void close() {
        if (this.thread == null) {
            return;
        }
        Thread oldThread = this.thread;
        this.thread = null;
        oldThread.interrupt();
    }

    public void startMonitoring() {
        if (this.thread != null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                InputStreamMonitor.this.writeStream();
            }
        };
        this.thread = new Thread(runnable, "Terminal Input Stream Monitor Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void writeStream() {
        while (this.thread != null && !this.disposed) {
            if (!this.queue.isEmpty()) ** GOTO lbl24
            var1_1 = this.queue;
            synchronized (var1_1) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException v0) {}
                if (true) ** GOTO lbl24
            }
            do {
                if ((data = this.queue.poll()) == null) continue;
                try {
                    this.stream.write(data);
                    this.stream.flush();
                }
                catch (IOException e) {
                    if (this.disposed) continue;
                    status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.InputStreamMonitor_error_writingToStream, (Object)e.getLocalizedMessage()), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
lbl24:
                // 6 sources

            } while (!this.queue.isEmpty() && !this.disposed);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Queue<byte[]> queue = this.queue;
        synchronized (queue) {
            this.queue.add(new byte[]{(byte)b});
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Queue<byte[]> queue = this.queue;
        synchronized (queue) {
            byte[] processedBytes = this.onWriteContentToStream(b, off, len);
            if (processedBytes != b) {
                off = 0;
                len = processedBytes.length;
            }
            byte[] bytes = new byte[len];
            int j = 0;
            int i = 0;
            while (i < len) {
                bytes[j++] = b[off + i];
                ++i;
            }
            this.queue.add(bytes);
            this.queue.notifyAll();
        }
    }

    protected byte[] onWriteContentToStream(byte[] bytes, int off, int len) {
        Assert.isNotNull((Object)bytes);
        if (this.replacement != 0 && len > 0) {
            String text = new String(bytes, off, len);
            if (this.replacement == 1) {
                text = text.replace('\r', '\n');
            } else if (this.replacement == 2) {
                text = text.replaceAll("\\r", "\r\n");
            } else if (this.replacement == 3) {
                text = text.replaceAll("\\r", "");
            } else if (this.replacement == 4) {
                text = text.replaceAll("\\n", "");
            }
            if (text.length() > 0) {
                bytes = text.getBytes();
            }
        }
        return bytes;
    }
}

