/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.tabs;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.ui.events.AbstractEventListener;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.terminals.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.events.SelectionChangedBroadcastEvent;
import org.eclipse.tcf.te.ui.terminals.interfaces.ITerminalsView;
import org.eclipse.tcf.te.ui.terminals.tabs.TabDisposeListener;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderMenuHandler;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderSelectionListener;
import org.eclipse.tcf.te.ui.terminals.tabs.TabTerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.emulator.VT100TerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDEEncoding;

public class TabFolderManager
extends PlatformObject
implements ISelectionProvider {
    private final ITerminalsView parentView;
    private final SelectionListener selectionListener;
    private final BroadcastedSelectionChangedEventListener broadcastedSelectionChangedEventListener;
    private final List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();

    public TabFolderManager(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        this.parentView = parentView;
        this.selectionListener = this.doCreateTabFolderSelectionListener(this);
        if (this.getTabFolder() != null) {
            this.getTabFolder().addSelectionListener(this.selectionListener);
        }
        this.broadcastedSelectionChangedEventListener = this.doCreateBroadcastedSelectionChangedEventListener(this);
        if (this.isListeningToBroadcastedSelectionChangedEvent() && this.broadcastedSelectionChangedEventListener != null) {
            EventManager.getInstance().addEventListener((IEventListener)this.broadcastedSelectionChangedEventListener, SelectionChangedBroadcastEvent.class);
        }
    }

    protected TabFolderSelectionListener doCreateTabFolderSelectionListener(TabFolderManager parent) {
        Assert.isNotNull((Object)((Object)parent));
        return new TabFolderSelectionListener(parent);
    }

    protected final ITerminalsView getParentView() {
        return this.parentView;
    }

    protected final CTabFolder getTabFolder() {
        return (CTabFolder)this.getParentView().getAdapter(CTabFolder.class);
    }

    protected final ISelectionChangedListener[] getSelectionChangedListeners() {
        return this.selectionChangedListeners.toArray(new ISelectionChangedListener[this.selectionChangedListeners.size()]);
    }

    public void dispose() {
        if (this.getTabFolder() != null && !this.getTabFolder().isDisposed()) {
            this.getTabFolder().removeSelectionListener(this.selectionListener);
        }
        if (this.broadcastedSelectionChangedEventListener != null) {
            EventManager.getInstance().removeEventListener((IEventListener)this.broadcastedSelectionChangedEventListener);
        }
    }

    public CTabItem createTabItem(String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        CTabItem item = null;
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null) {
            ITerminalViewControl terminal;
            block9: {
                Menu menu;
                TabFolderMenuHandler menuHandler;
                String contextHelpId;
                title = this.makeUniqueTitle(title, tabFolder);
                item = new CTabItem(tabFolder, 64);
                item.setText(title);
                Image image = this.getTabItemImage(connector, data);
                if (image != null) {
                    item.setImage(image);
                }
                this.setupTerminalTabListeners(item);
                Composite composite = new Composite((Composite)tabFolder, 0);
                composite.setLayout((Layout)new FillLayout());
                item.setControl((Control)composite);
                tabFolder.getParent().layout(true);
                terminal = TerminalViewControlFactory.makeControl((ITerminalListener)this.doCreateTerminalTabTerminalListener(item), (Composite)composite, (ITerminalConnector[])new ITerminalConnector[]{connector}, (boolean)true);
                new TerminalControlSelectionListener(terminal);
                try {
                    terminal.setEncoding(IDEEncoding.getResourceEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                item.setData((Object)terminal);
                if (data != null) {
                    item.setData("customData", data);
                }
                if ((contextHelpId = this.getParentView().getContextHelpId()) != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(terminal.getControl(), contextHelpId);
                }
                if ((menuHandler = (TabFolderMenuHandler)((Object)this.getParentView().getAdapter(TabFolderMenuHandler.class))) != null && (menu = (Menu)menuHandler.getAdapter(Menu.class)) != null) {
                    try {
                        terminal.getControl().setMenu(menu);
                    }
                    catch (IllegalArgumentException e) {
                        if (!UIPlugin.getTraceHandler().isSlotEnabled(1, null)) break block9;
                        e.printStackTrace();
                    }
                }
            }
            tabFolder.setSelection(item);
            terminal.setConnector(connector);
            terminal.connectTerminal();
            this.fireSelectionChanged();
        }
        return item;
    }

    public CTabItem cloneTabItemAfterDrop(CTabItem oldItem) {
        Assert.isNotNull((Object)oldItem);
        ITerminalViewControl terminal = (ITerminalViewControl)oldItem.getData();
        ITerminalConnector connector = terminal.getTerminalConnector();
        Object data = oldItem.getData("customData");
        String title = oldItem.getText();
        CTabItem item = null;
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null) {
            block7: {
                Menu menu;
                TabFolderMenuHandler menuHandler;
                String contextHelpId;
                title = this.makeUniqueTitle(title, tabFolder);
                item = new CTabItem(tabFolder, 64);
                item.setText(title);
                Image image = this.getTabItemImage(connector, data);
                if (image != null) {
                    item.setImage(image);
                }
                this.setupTerminalTabListeners(item);
                Composite composite = new Composite((Composite)tabFolder, 0);
                composite.setLayout((Layout)new FillLayout());
                item.setControl((Control)composite);
                tabFolder.getParent().layout(true);
                Assert.isTrue((boolean)(terminal instanceof VT100TerminalControl));
                ((VT100TerminalControl)terminal).setupTerminal(composite);
                item.setData((Object)terminal);
                if (data != null) {
                    item.setData("customData", data);
                }
                if ((contextHelpId = this.getParentView().getContextHelpId()) != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(terminal.getControl(), contextHelpId);
                }
                if ((menuHandler = (TabFolderMenuHandler)((Object)this.getParentView().getAdapter(TabFolderMenuHandler.class))) != null && (menu = (Menu)menuHandler.getAdapter(Menu.class)) != null) {
                    try {
                        terminal.getControl().setMenu(menu);
                    }
                    catch (IllegalArgumentException e) {
                        if (!UIPlugin.getTraceHandler().isSlotEnabled(1, null)) break block7;
                        e.printStackTrace();
                    }
                }
            }
            tabFolder.setSelection(item);
            terminal.setConnector(connector);
            Assert.isTrue((boolean)(terminal instanceof ITerminalControl));
            ((ITerminalControl)terminal).setState(TerminalState.CONNECTED);
            this.fireSelectionChanged();
        }
        return item;
    }

    protected String makeUniqueTitle(String proposal, CTabFolder tabFolder) {
        Assert.isNotNull((Object)proposal);
        Assert.isNotNull((Object)tabFolder);
        String title = proposal;
        int index = 0;
        ArrayList<String> titles = new ArrayList<String>();
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            titles.add(item.getText());
            while (titles.contains(title)) {
                title = String.valueOf(proposal) + " (" + index++ + ")";
            }
            ++n2;
        }
        return title;
    }

    protected void setupTerminalTabListeners(CTabItem item) {
        Assert.isNotNull((Object)item);
        DisposeListener disposeListener = this.doCreateTerminalTabDisposeListener(this);
        item.setData("disposeListener", (Object)disposeListener);
        item.addDisposeListener(disposeListener);
    }

    protected ITerminalListener doCreateTerminalTabTerminalListener(CTabItem item) {
        Assert.isNotNull((Object)item);
        return new TabTerminalListener(item);
    }

    protected DisposeListener doCreateTerminalTabDisposeListener(TabFolderManager parent) {
        Assert.isNotNull((Object)((Object)parent));
        return new TabDisposeListener(parent);
    }

    protected Image getTabItemImage(ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)connector);
        return UIPlugin.getImage("TerminalsView");
    }

    public CTabItem findTabItem(String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return null;
        }
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (!item.isDisposed()) {
                String itemTitle = item.getText();
                if ((itemTitle = itemTitle.replaceFirst("^<.*>\\s*", "")).startsWith(title)) {
                    ITerminalViewControl terminal = (ITerminalViewControl)item.getData();
                    ITerminalConnector connector2 = terminal.getTerminalConnector();
                    if (connector.getId().equals(connector2.getId()) && connector.getName().equals(connector2.getName())) {
                        String summary2;
                        if (!connector.isInitialized()) {
                            return item;
                        }
                        String summary = connector.getSettingsSummary();
                        if (summary.equals(summary2 = connector2.getSettingsSummary())) {
                            return item;
                        }
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public void bringToTop(CTabItem item) {
        Assert.isNotNull((Object)item);
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return;
        }
        tabFolder.setSelection(item);
        this.fireSelectionChanged();
    }

    public CTabItem getActiveTabItem() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return null;
        }
        return tabFolder.getSelection();
    }

    public void removeTerminatedItems() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return;
        }
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (!item.isDisposed() && this.isTerminatedTabItem(item)) {
                item.dispose();
            }
            ++n2;
        }
    }

    protected boolean isTerminatedTabItem(CTabItem item) {
        if (item == null || item.isDisposed()) {
            return false;
        }
        String itemTitle = item.getText();
        if (itemTitle != null && itemTitle.contains("<terminated>")) {
            return true;
        }
        ITerminalViewControl terminal = (ITerminalViewControl)item.getData();
        return terminal != null && terminal.getState() == TerminalState.CLOSED;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        CTabItem activeTabItem = this.getActiveTabItem();
        return activeTabItem != null ? new StructuredSelection((Object)activeTabItem) : new StructuredSelection();
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object candidate : (IStructuredSelection)selection) {
                if (!(candidate instanceof CTabItem)) continue;
                this.bringToTop((CTabItem)candidate);
                return;
            }
        }
        this.fireSelectionChanged(selection);
    }

    protected void fireSelectionChanged() {
        this.fireSelectionChanged(this.getSelection());
    }

    protected final void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(event);
        }
        if (this.isBroadcastSelectionChangedEvent()) {
            this.onBroadcastSelectionChangedEvent(event);
        }
    }

    protected boolean isBroadcastSelectionChangedEvent() {
        return false;
    }

    protected void onBroadcastSelectionChangedEvent(SelectionChangedEvent selectionChangedEvent) {
        SelectionChangedBroadcastEvent event = this.doCreateSelectionChangedBroadcastEvent(this, selectionChangedEvent);
        if (event != null) {
            EventManager.getInstance().fireEvent((EventObject)event);
        }
    }

    protected SelectionChangedBroadcastEvent doCreateSelectionChangedBroadcastEvent(TabFolderManager source, SelectionChangedEvent selectionChangedEvent) {
        return new SelectionChangedBroadcastEvent(source, selectionChangedEvent);
    }

    protected boolean isListeningToBroadcastedSelectionChangedEvent() {
        return false;
    }

    protected BroadcastedSelectionChangedEventListener doCreateBroadcastedSelectionChangedEventListener(TabFolderManager parent) {
        return new BroadcastedSelectionChangedEventListener(parent);
    }

    private class BroadcastedSelectionChangedEventListener
    extends AbstractEventListener {
        private final TabFolderManager parent;

        public BroadcastedSelectionChangedEventListener(TabFolderManager parent) {
            Assert.isNotNull((Object)((Object)parent));
            this.parent = parent;
        }

        public void eventFired(EventObject event) {
            if (event instanceof SelectionChangedBroadcastEvent && !event.getSource().equals((Object)this.parent)) {
                CTabFolder tabFolder = this.parent.getTabFolder();
                if (tabFolder == null || tabFolder.isDisposed() || tabFolder.getItemCount() == 0) {
                    return;
                }
                SelectionChangedEvent selectionChangedEvent = ((SelectionChangedBroadcastEvent)event).getSelectionChangedEvent();
                if (selectionChangedEvent != null && selectionChangedEvent.getSelection() instanceof IStructuredSelection && !selectionChangedEvent.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    CTabItem item = null;
                    for (Object candidate : selection) {
                        if (!(candidate instanceof CTabItem)) continue;
                        item = (CTabItem)candidate;
                        break;
                    }
                    if (item != null && item.getData("customData") != null) {
                        CTabItem[] ourItems;
                        Object data = item.getData("customData");
                        CTabItem[] cTabItemArray = ourItems = tabFolder.getItems();
                        int n = ourItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CTabItem ourItem = cTabItemArray[n2];
                            Object ourData = ourItem.getData("customData");
                            if (data.equals(ourData) && !ourItem.equals(this.parent.getActiveTabItem())) {
                                this.parent.setSelection((ISelection)new StructuredSelection((Object)ourItem));
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
    }

    private class TerminalControlSelectionListener
    implements DisposeListener,
    MouseListener {
        private final ITerminalViewControl terminal;
        private boolean selectMode;

        public TerminalControlSelectionListener(ITerminalViewControl terminal) {
            Assert.isNotNull((Object)terminal);
            this.terminal = terminal;
            terminal.getControl().addDisposeListener((DisposeListener)this);
            terminal.getControl().addMouseListener((MouseListener)this);
        }

        protected final ITerminalViewControl getTerminal() {
            return this.terminal;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.getSource().equals(this.terminal.getControl())) {
                this.getTerminal().getControl().removeDisposeListener((DisposeListener)this);
                this.getTerminal().getControl().removeMouseListener((MouseListener)this);
            }
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                this.selectMode = true;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1 && this.selectMode) {
                this.selectMode = false;
                DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TabFolderManager.this.fireSelectionChanged((ISelection)new StructuredSelection((Object)TerminalControlSelectionListener.this.getTerminal().getSelection()));
                    }
                });
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

