/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tcf.te.ui.terminals.actions.TabScrollLockAction;
import org.eclipse.tcf.te.ui.terminals.interfaces.ITerminalsView;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderManager;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.AbstractTerminalAction;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionSelectAll;

public class TabFolderMenuHandler
extends PlatformObject {
    private final ITerminalsView parentView;
    private MenuManager contextMenuManager;
    private Menu contextMenu;
    private final List<AbstractTerminalAction> contextMenuActions = new ArrayList<AbstractTerminalAction>();

    public TabFolderMenuHandler(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        this.parentView = parentView;
    }

    protected final ITerminalsView getParentView() {
        return this.parentView;
    }

    protected final CTabFolder getTabFolder() {
        return (CTabFolder)this.getParentView().getAdapter(CTabFolder.class);
    }

    public void dispose() {
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
            this.contextMenuManager = null;
        }
        this.contextMenuActions.clear();
    }

    public void initialize() {
        if (this.contextMenuManager != null && this.contextMenu != null) {
            return;
        }
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return;
        }
        this.contextMenuManager = new MenuManager("#PopupMenu");
        this.contextMenuManager.addMenuListener((IMenuListener)new MenuListener());
        this.contextMenu = this.contextMenuManager.createContextMenu((Control)tabFolder);
        this.doCreateContextMenuActions();
        this.doFillContextMenu(this.contextMenuManager);
        this.getParentView().getSite().registerContextMenu(this.contextMenuManager, this.getParentView().getSite().getSelectionProvider());
    }

    protected final void add(AbstractTerminalAction action) {
        Assert.isNotNull((Object)action);
        this.contextMenuActions.add(action);
    }

    protected void doCreateContextMenuActions() {
        this.add((AbstractTerminalAction)new TerminalActionCopy(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionPaste(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionClearAll(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionSelectAll(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add(new TabScrollLockAction(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
    }

    protected ITerminalViewControl getActiveTerminalViewControl() {
        CTabItem activeTabItem;
        ITerminalViewControl terminal = null;
        TabFolderManager manager = (TabFolderManager)((Object)this.getParentView().getAdapter(TabFolderManager.class));
        if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null) {
            terminal = (ITerminalViewControl)activeTabItem.getData();
        }
        return terminal;
    }

    protected void doFillContextMenu(MenuManager manager) {
        Assert.isNotNull((Object)manager);
        for (AbstractTerminalAction action : this.contextMenuActions) {
            manager.add((IAction)action);
            if (action instanceof TerminalActionPaste) {
                manager.add((IContributionItem)new Separator());
            }
            if (!(action instanceof TerminalActionSelectAll)) continue;
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void updateMenuItems(boolean aboutToShow) {
        for (AbstractTerminalAction action : this.contextMenuActions) {
            action.updateAction(aboutToShow);
        }
    }

    public Object getAdapter(Class adapter) {
        if (MenuManager.class.isAssignableFrom(adapter)) {
            return this.contextMenuManager;
        }
        if (Menu.class.isAssignableFrom(adapter)) {
            return this.contextMenu;
        }
        Object adapted = this.getParentView().getAdapter(adapter);
        if (adapted != null) {
            return adapted;
        }
        return super.getAdapter(adapter);
    }

    protected class MenuListener
    implements IMenuListener2 {
        protected MenuListener() {
        }

        public void menuAboutToHide(IMenuManager manager) {
        }

        public void menuAboutToShow(IMenuManager manager) {
            TabFolderMenuHandler.this.updateMenuItems(true);
        }
    }
}

