/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.statushandler;

import java.lang.constant.Constable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.statushandler.AbstractStatusHandler;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.jface.dialogs.OptionalMessageDialog;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class DefaultStatusHandler
extends AbstractStatusHandler {
    protected static final String QUESTION_TITLE = Messages.DefaultStatusHandler_question_title;
    protected static final String WARNING_TITLE = Messages.DefaultStatusHandler_warning_title;
    protected static final String ERROR_TITLE = Messages.DefaultStatusHandler_error_title;
    protected static final String INFORMATION_TITLE = Messages.DefaultStatusHandler_information_title;
    protected static final String[] EMPTY = new String[0];

    public void handleStatus(final IStatus status, final IPropertiesContainer data, final ICallback done) {
        Assert.isNotNull((Object)status);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!PlatformUI.isWorkbenchRunning() || display == null || display.isDisposed()) {
            return;
        }
        if (Thread.currentThread().equals(display.getThread())) {
            this.doHandleStatus(status, data, done);
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DefaultStatusHandler.this.doHandleStatus(status, data, done);
                }
            });
        }
    }

    protected void doHandleStatus(IStatus status, IPropertiesContainer data, ICallback done) {
        Assert.isNotNull((Object)status);
        Assert.isTrue((boolean)Thread.currentThread().equals(PlatformUI.getWorkbench().getDisplay().getThread()));
        Object result = null;
        Throwable error = null;
        try {
            try {
                String message = status.getMessage();
                String pluginId = status.getPlugin();
                int code = status.getCode();
                int severity = status.getSeverity();
                Throwable exception = status.getException();
                String title = null;
                String[] buttonLabel = null;
                String contextHelpId = null;
                String dontAskAgainId = null;
                Object caller = null;
                if (data != null) {
                    title = data.getStringProperty("title");
                    buttonLabel = (String[])data.getProperty("buttonLabel");
                    contextHelpId = data.getStringProperty("contextHelpId");
                    dontAskAgainId = data.getStringProperty("dontAskAgainId");
                    caller = data.getProperty("caller");
                }
                if (message != null && pluginId != null) {
                    Shell shell = null;
                    if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() != null) {
                        shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    }
                    severity = this.adjustSeverity(severity, exception);
                    title = this.adjustTitle(title, severity, exception);
                    message = this.adjustMessage(message, severity, exception, caller);
                    if (Host.isInteractive() && shell != null) {
                        String[] contextHelpIds;
                        if (title == null) {
                            switch (severity) {
                                case 256: 
                                case 512: {
                                    title = QUESTION_TITLE;
                                    break;
                                }
                                case 2: {
                                    title = WARNING_TITLE;
                                    break;
                                }
                                case 4: {
                                    title = ERROR_TITLE;
                                    break;
                                }
                                default: {
                                    title = INFORMATION_TITLE;
                                }
                            }
                        }
                        if (severity == 2 || severity == 4) {
                            UIPlugin.getDefault().getLog().log(status);
                        }
                        String helpContextId = (contextHelpIds = this.adjustContextHelpIds(contextHelpId, code, caller)).length > 0 ? contextHelpIds[0] : null;
                        result = this.doOpenMessageDialog(shell, title, message, buttonLabel, severity, dontAskAgainId, helpContextId);
                    } else {
                        int newSeverity = severity;
                        if (newSeverity != 0 && newSeverity != 1 && newSeverity != 8 && newSeverity != 2 && newSeverity != 4) {
                            newSeverity = 0;
                        }
                        status = new Status(newSeverity, pluginId, code, message, exception);
                        UIPlugin.getDefault().getLog().log(status);
                    }
                }
                if (data == null && result != null) {
                    data = new PropertiesContainer();
                }
                if (data != null) {
                    data.setProperty("result", result);
                }
            }
            catch (Throwable e) {
                error = e;
                if (done != null) {
                    done.setResult((Object)data);
                    done.done((Object)this, StatusHelper.getStatus((Throwable)error));
                }
            }
        }
        finally {
            if (done != null) {
                done.setResult((Object)data);
                done.done((Object)this, StatusHelper.getStatus((Throwable)error));
            }
        }
    }

    protected int adjustSeverity(int proposedSeverity, Throwable exception) {
        return proposedSeverity;
    }

    protected String adjustTitle(String proposedTitle, int severity, Throwable exception) {
        return proposedTitle;
    }

    protected String adjustMessage(String proposedMessage, int severity, Throwable exception, Object caller) {
        return proposedMessage;
    }

    protected String[] adjustContextHelpIds(String proposedContextHelpId, int errorCode, Object caller) {
        if (proposedContextHelpId == null) {
            return EMPTY;
        }
        return new String[]{proposedContextHelpId};
    }

    protected Object doOpenMessageDialog(Shell shell, String title, String message, String[] buttonLabel, int severity, String keyDontAskAgain, String helpContextId) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)message);
        Constable result = null;
        switch (severity) {
            case 256: {
                result = new Boolean(OptionalMessageDialog.openYesNoDialog((Shell)shell, (String)title, (String)message, (String[])buttonLabel, (String)keyDontAskAgain, (String)helpContextId) == 2);
                break;
            }
            case 512: {
                result = new Integer(OptionalMessageDialog.openYesNoCancelDialog((Shell)shell, (String)title, (String)message, (String[])buttonLabel, (String)keyDontAskAgain, (String)helpContextId));
                break;
            }
            case 2: {
                OptionalMessageDialog.openWarningDialog((Shell)shell, (String)title, (String)message, (String[])buttonLabel, (String)keyDontAskAgain, (String)helpContextId);
                break;
            }
            case 4: {
                OptionalMessageDialog.openErrorDialog((Shell)shell, (String)title, (String)message, (String[])buttonLabel, (String)keyDontAskAgain, (String)helpContextId);
                break;
            }
            default: {
                OptionalMessageDialog.openInformationDialog((Shell)shell, (String)title, (String)message, (String[])buttonLabel, (String)keyDontAskAgain, (String)helpContextId);
            }
        }
        return result;
    }
}

