/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.ui.trees.TreeViewerLabelProvider;

public class TreeViewerDecoratingLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    private TreeViewerLabelProvider fProvider;
    private ILabelDecorator fDecorator;

    public TreeViewerDecoratingLabelProvider(TreeViewerLabelProvider provider, ILabelDecorator decorator) {
        super((ILabelProvider)provider, decorator);
        this.fProvider = provider;
        this.fDecorator = decorator;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = this.fProvider.getColumnImage(element, columnIndex);
        if (columnIndex == 0 && this.fDecorator != null) {
            if (this.fDecorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.fDecorator;
                Image decorated = ld2.decorateImage(image, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                Image decorated = this.fDecorator.decorateImage(image, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = this.fProvider.getColumnText(element, columnIndex);
        if (columnIndex == 0 && this.fDecorator != null) {
            if (this.fDecorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.fDecorator;
                String decorated = ld2.decorateText(text, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                String decorated = this.fDecorator.decorateText(text, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return text;
    }
}

